/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.flow.common.IConfigurationProvider;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.api.ResultCommon;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcCommon;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.model.entity.principal.PrincipalContext;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonMapperTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.ThreadContextAwareResolver;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import de.intarsys.tools.nls.INlsContext;
import de.intarsys.tools.nls.NlsContext;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import de.intarsys.tools.zones.ZoneSpec;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SvcRepositoryBased<R extends ResultCommon, C extends FlowConfiguration>
extends SvcCommon<R> {
    public static final String RESOLVER_FLOW = "flow";
    public static final String RESOLVER_PRINCIPAL = "principal";
    public static final String RESOLVER_SIGNERCREATE = "signerCreate";
    public static final String ARG_SIGNER_CREATE = "signerCreate";
    private static final Object PROP_AUTHENTICATION = new Object();
    @Autowired
    private PrincipalContext principalContext;
    @Autowired
    private IRepository repository;
    @Autowired
    private IConfigurationProvider configurationProvider;
    private ObjectMapper objectMapper;

    protected C createConfiguration(Object configuration) {
        C result = FlowConfiguration.createConfiguration(configuration, this.getConfigurationType(), this.getConfigurationProvider(), this.getObjectMapper());
        if (result == null) {
            result = this.createDefaultConfiguration();
        }
        return result;
    }

    protected abstract C createDefaultConfiguration();

    protected ObjectMapper createObjectMapper() {
        return JacksonMapperTools.createObjectMapper(this.getRepository());
    }

    protected MapResolver createResolver(CommonFlow flow) {
        MapResolver mapResolver = MapResolver.createStrict();
        mapResolver.put(RESOLVER_FLOW, (Object)new ReflectiveResolver((Object)flow));
        mapResolver.put(RESOLVER_PRINCIPAL, (Object)this.getPrincipalContext());
        return mapResolver;
    }

    protected IZone createZone(CoreFlow flow) {
        ZoneSpec spec = new ZoneSpec();
        HashMap stackState = new HashMap();
        spec.setOnEnter(zone -> this.runInContextBefore(stackState, flow));
        spec.setOnLeave(zone -> this.runInContextAfter(stackState, flow));
        IZone zone2 = Zone.getCurrent().fork(spec);
        return zone2;
    }

    protected C getConfiguration(RequestFlowCreate request) {
        C config = this.createConfiguration(request.getConfiguration());
        ArgTools.putAllDeep((IArgs)((FlowConfiguration)config).getVariables(), (IArgs)request.getVariables());
        return config;
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected abstract Class<C> getConfigurationType();

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected PrincipalContext getPrincipalContext() {
        return this.principalContext;
    }

    protected IRepository getRepository() {
        return this.repository;
    }

    @PostConstruct
    public void init() {
        this.objectMapper = this.createObjectMapper();
    }

    protected RepositoryItem resolveRepoPath(String path) {
        try {
            return this.getRepository().lookupItem(path);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("failed read repository data '" + path + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runInContext(CoreFlow flow, Throwing.Specific.Function<CommonFlow, T, Exception> f) throws Exception {
        HashMap stackState = new HashMap();
        this.runInContextBefore(stackState, flow);
        try {
            Object object = f.apply((Object)flow);
            return (T)object;
        }
        finally {
            this.runInContextAfter(stackState, flow);
            stackState.clear();
        }
    }

    protected void runInContextAfter(Map stackState, CoreFlow flow) {
        ThreadContextAwareResolver.detach((IStringEvaluator)flow.getAdditionalResolvers());
        RestrictedIdentificationProvider.leave();
        this.getPrincipalContext().leave();
        IAuthentication oldAuthentication = (IAuthentication)stackState.get(PROP_AUTHENTICATION);
        AuthenticationProvider.get().setAuthentication(oldAuthentication);
        NlsContext.get().popLocale();
    }

    protected void runInContextBefore(Map stackState, CoreFlow flow) {
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        String lang = FlowOptions.getLang((IOptionSupport)flow);
        INlsContext nlsContext = NlsContext.get();
        if (StringTools.isEmpty((String)lang) || nlsContext.isLocalePushed()) {
            nlsContext.pushLocale(nlsContext.getLocale());
        } else {
            Locale locale = Locale.forLanguageTag(lang);
            nlsContext.pushLocale(locale);
        }
        String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)flow);
        RestrictedIdentificationProvider.enter(ri);
        IAuthentication oldAuthentication = AuthenticationProvider.get().getAuthentication();
        IAuthentication flowAuthentiction = flow.getAuthenticationContext();
        AuthenticationProvider.get().setAuthentication(flowAuthentiction);
        stackState.put(PROP_AUTHENTICATION, oldAuthentication);
        this.getPrincipalContext().enter(flow);
        ThreadContextAwareResolver.attach((IStringEvaluator)flow.getAdditionalResolvers());
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

