/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.gears.assertion.AssertionTools;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.api.ResultCommon;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcRepositoryBased;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.tools.common.ArgsTransformer;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.MonitorConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.ZoneAwareResolver;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SvcRepositoryBasedProcessor<R extends ResultCommon, C extends FlowConfiguration, F extends RepositoryBasedFlow>
extends SvcRepositoryBased<R, C> {
    public static final String RESOLVER_FLOW = "flow";
    public static final String RESOLVER_PRINCIPAL = "principal";
    private static final Logger Log = LoggerFactory.getLogger(SvcRepositoryBasedProcessor.class);

    protected F createFlow(RequestFlowCreate request, Supplier<F> flowCreator) {
        RepositoryBasedFlow flow = (RepositoryBasedFlow)flowCreator.get();
        ExecutorService tmpExecutor = FlowOptions.isAsynch((IOptionSupport)request) ? executor : new SynchronousExecutorService();
        MonitorConversation r = new MonitorConversation("monitor", tmpExecutor);
        r.exceptionally(ex -> {
            flow.dispose();
            throw Conversation.rethrowable((Throwable)ex);
        });
        flow.setConversation((IConversation<?>)r);
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        return (F)flow;
    }

    protected IConversation<R> createMainConversation(F flow, Function<F, IConversation<R>> processor) {
        this.runAssertions((CommonFlow)flow, "before");
        if (!FlowOptions.isInternalCall(flow)) {
            SvcRepositoryBasedProcessor.authorizeArgs(this.getServicePath(), ((CommonFlow)flow).getArgs());
        }
        if (((CommonFlow)flow).getConfiguration().getArguments() != null) {
            ArgsTransformer transformer = new ArgsTransformer(((CommonFlow)flow).getConfiguration().getArguments(), true);
            ((CommonFlow)flow).setArgs(transformer.apply(((CommonFlow)flow).getArgs()));
        }
        IConversation<R> convProcess = this.process(flow, processor);
        return convProcess;
    }

    protected IConversation<?> doCreate(RequestFlowCreate request, Supplier<F> flowCreator, Function<F, IConversation<R>> processor) {
        F flow = this.createFlow(request, flowCreator);
        IZone zone = this.createZone((CoreFlow)flow);
        try {
            this.prepareFlow(flow, request);
            zone.wrap(f -> {
                flow.setConfiguration((FlowConfiguration)this.getConfiguration(request));
                this.createEncryption((RepositoryBasedFlow)flow);
                IntegrationOptions integrationOptions = FlowOptions.getIntegrationOptions((IOptionSupport)flow);
                ConversationServiceTools.setRootConversation(flow.getConversation());
                ConversationServiceTools.setIntegrationOptions(flow.getConversation(), (IntegrationOptions)integrationOptions);
                flow.getConversation().monitor(zone.wrap((Throwing.Specific.Supplier)((Throwing.Supplier)() -> this.createMainConversation(flow, processor))));
            }).accept(flow);
        }
        catch (Exception e) {
            ((CommonFlow)flow).getConversation().completeExceptionally((Throwable)e);
        }
        ((CommonFlow)flow).getConversation().forwardTermination();
        this.getConversationRegistry().publish(((CommonFlow)flow).getConversation());
        return ((CommonFlow)flow).getConversation();
    }

    protected abstract String getServicePath();

    protected void prepareFlow(F flow, RequestFlowCreate request) {
        IAuthentication authentication = AuthenticationProvider.get().getAuthentication();
        ((CoreFlow)flow).setAuthenticationContext(authentication);
        ((CommonFlow)flow).setLabel(request.getLabel());
        ((CommonFlow)flow).setOptions(request.getOptions());
        ((CommonFlow)flow).setArgs(request.getArgs());
        ((RepositoryBasedFlow)flow).setRepoDocStates(this.createRepoDocStates(request));
        ((CoreFlow)flow).addAdditionalResolver((IStringEvaluator)this.createResolver((CommonFlow)flow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<R> process(F flow, Function<F, IConversation<R>> processor) {
        MapResolver resolver = MapResolver.create();
        resolver.put(RESOLVER_FLOW, (Object)new ReflectiveResolver(flow));
        resolver.put(RESOLVER_PRINCIPAL, (Object)this.getPrincipalContext());
        try {
            ZoneAwareResolver.attach((IStringEvaluator)resolver);
            IConversation<R> iConversation = processor.apply(flow);
            return iConversation;
        }
        finally {
            ZoneAwareResolver.detach((IStringEvaluator)resolver);
        }
    }

    protected void runAssertionsBefore(F flow) {
        Args argsCheck = Args.create();
        argsCheck.put("service", (Object)this);
        argsCheck.put(RESOLVER_FLOW, flow);
        AssertionTools.runAssertionsBefore(flow, (IArgs)argsCheck);
    }
}

