/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.flow.common;

import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.flow.common.ResourceInUseException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public abstract class CoreFlow
extends CommonFlow {
    private final List<ActionInvocation> invocations = new ArrayList<ActionInvocation>();
    private List<DtoArtifact> artifacts = new ArrayList<DtoArtifact>();
    private IAuthentication authenticationContext;
    private ScopedResolver additionalResolvers = new ScopedResolver();

    public void addAdditionalResolver(IStringEvaluator additionalResolver) {
        this.additionalResolvers.addResolver(additionalResolver);
    }

    public void addArtifact(DtoArtifact artifact) {
        try {
            ListIterator<DtoArtifact> it = this.artifacts.listIterator();
            while (it.hasNext()) {
                DtoArtifact next = it.next();
                if (!next.equals((Object)artifact)) continue;
                it.set(artifact);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.artifacts.add(artifact);
    }

    public IStringEvaluator getAdditionalResolvers() {
        return this.additionalResolvers;
    }

    public List<DtoArtifact> getArtifacts() {
        return this.artifacts;
    }

    public IAuthentication getAuthenticationContext() {
        return this.authenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionInvocation> getInvocations() {
        CoreFlow coreFlow = this;
        synchronized (coreFlow) {
            return new ArrayList<ActionInvocation>(this.invocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationAcquire(ActionInvocation invocation, Object resource) {
        CoreFlow coreFlow = this;
        synchronized (coreFlow) {
            for (ActionInvocation current : this.invocations) {
                if (!current.getResources().contains(resource)) continue;
                if (current == invocation) {
                    return;
                }
                throw new ResourceInUseException(current, resource);
            }
            invocation.getResources().add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationBegin(ActionInvocation invocation) {
        CoreFlow coreFlow = this;
        synchronized (coreFlow) {
            this.invocations.add(invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationDispose(ActionInvocation invocation) {
        CoreFlow coreFlow = this;
        synchronized (coreFlow) {
            this.invocations.remove(invocation);
        }
    }

    public void setArtifact(DtoArtifact artifact) {
        Predicate<DtoArtifact> matcher;
        String tmpRole = artifact.getRole();
        if (StringTools.isEmpty((String)tmpRole)) {
            String tmpClass = artifact.getValue() == null ? "Void" : artifact.getValue().getClass().getName();
            matcher = other -> {
                String otherClass = other.getValue() == null ? "Void" : other.getValue().getClass().getName();
                return LangTools.equals((Object)tmpClass, (Object)otherClass);
            };
        } else {
            matcher = other -> LangTools.equals((Object)tmpRole, (Object)other.getRole());
        }
        ListIterator<DtoArtifact> it = this.artifacts.listIterator();
        while (it.hasNext()) {
            DtoArtifact next = it.next();
            if (!matcher.test(next)) continue;
            it.set(artifact);
            return;
        }
        this.artifacts.add(artifact);
    }

    public void setAuthenticationContext(IAuthentication authenticationContext) {
        this.authenticationContext = authenticationContext;
    }
}

