/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.flow.common;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryTools;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryBasedFlow
extends CoreFlow {
    private static final Logger Log = LoggerFactory.getLogger(RepositoryBasedFlow.class);
    public static final String ATTR_CS_VIEWED = "cs.viewed";
    public static final String ARG_HANDLE = "handle";
    public static final String ATTR_CS_SIGNED = "cs.signed";
    private final IRepository repository;
    private List<RepositoryDocumentState> repoDocStates;

    public RepositoryBasedFlow(IRepository repository) {
        this.repository = repository;
    }

    @Override
    protected String createDefaultLabel() {
        if (this.getRepoDocStates() == null || this.getRepoDocStates().isEmpty()) {
            return "";
        }
        RepositoryDocument repoDoc = this.getRepoDocStates().iterator().next().getRepoDoc();
        return repoDoc.getMetadata().getName();
    }

    public TransportDocument createTransportDoc(IArgs document) {
        RepositoryDocumentState repoDocState = this.resolveRepoDocState(document);
        return this.createTransportDoc(repoDocState);
    }

    public TransportDocument createTransportDoc(RepositoryDocumentState repoDocState) {
        if (repoDocState == null) {
            return null;
        }
        TransportDocument transportDoc = new TransportDocument();
        IArgs properties = repoDocState.getRepoDoc().getProperties().getProperties();
        transportDoc.addProperties(properties);
        transportDoc.setHandle(repoDocState.getRepoDoc().getLocator());
        JacksonTools.setRepositoryItem((TransportItem)transportDoc, repoDocState.getRepoDoc());
        return transportDoc;
    }

    public List<TransportDocument> createTransportDocAll() {
        ArrayList<TransportDocument> transportList = new ArrayList<TransportDocument>();
        for (RepositoryDocumentState itemState : this.getRepoDocStates()) {
            transportList.add(this.createTransportDoc(itemState));
        }
        return transportList;
    }

    public TransportDocument createTransportDocFirst() {
        Iterator<RepositoryDocumentState> iterator = this.getRepoDocStates().iterator();
        if (iterator.hasNext()) {
            RepositoryDocumentState itemState = iterator.next();
            return this.createTransportDoc(itemState);
        }
        return null;
    }

    public List<TransportDocument> createTransportDocList(IArgs documents) {
        if (documents == null) {
            return null;
        }
        ArrayList<TransportDocument> transportList = new ArrayList<TransportDocument>();
        for (IArgs.IBinding binding : documents) {
            transportList.add(this.createTransportDoc((IArgs)binding.getValue()));
        }
        return transportList;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.getRepoDocStates() != null) {
            RepositoryItem importFolder = null;
            for (RepositoryDocumentState repoDocState : this.getRepoDocStates()) {
                if (!repoDocState.isImported()) continue;
                RepositoryDocument importDoc = repoDocState.getRepoDoc();
                try {
                    if (!importDoc.getParent().isRoot()) {
                        importFolder = importDoc.getParent();
                    }
                    importDoc.delete();
                }
                catch (Exception e) {
                    Log.warn("{} failed to dispose imported item {}", (Object)this, (Object)importDoc.getPath());
                }
            }
            if (importFolder != null) {
                try {
                    importFolder.delete();
                }
                catch (Exception e) {
                    Log.warn("{} failed to dispose import folder {}", (Object)this, (Object)importFolder.getPath());
                }
            }
        }
    }

    public List<RepositoryDocumentState> getRepoDocStates() {
        return this.repoDocStates;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public abstract boolean isMultiDocumentSupport();

    public RepositoryDocumentState resolveRepoDocState(IArgs document) {
        if (document == null) {
            return null;
        }
        String uri = ArgTools.getString((IArgs)document, (String)ARG_HANDLE, null);
        return this.resolveRepoDocStateByUri(uri);
    }

    public RepositoryDocumentState resolveRepoDocState(TransportDocument document) {
        if (document == null) {
            return null;
        }
        if (!document.isLink()) {
            throw new IllegalArgumentException("need a link");
        }
        ILocator locator = document.getLocator();
        return this.resolveRepoDocStateByUri(locator.toURI().toString());
    }

    public RepositoryDocumentState resolveRepoDocStateByName(String name) {
        for (RepositoryDocumentState itemState : this.getRepoDocStates()) {
            if (!itemState.getRepoDoc().getLocator().getName().equals(name)) continue;
            return itemState;
        }
        throw new InternalServerErrorException("invalid repository document name '" + name + "'");
    }

    public RepositoryDocumentState resolveRepoDocStateByUri(String uri) {
        String requestedPath = URI.create(uri).getPath();
        if (requestedPath.startsWith("/")) {
            requestedPath = requestedPath.substring(1);
        }
        for (RepositoryDocumentState itemState : this.getRepoDocStates()) {
            if (!itemState.getRepoPath().equals(requestedPath)) continue;
            return itemState;
        }
        throw new InternalServerErrorException("invalid repository reference '" + requestedPath + "'");
    }

    protected RepositoryItem resolveRepoUri(String uri) {
        try {
            return RepositoryTools.resolveUri(this.getRepository(), uri);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("failed read repository data '" + uri + "'", (Throwable)e);
        }
    }

    public void setRepoDocStates(List<RepositoryDocumentState> repoLinks) {
        this.repoDocStates = repoLinks;
    }
}

