/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.entity.principal;

import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ClaimValueConverter {
    public static Object convertObject(Object value) {
        return new ClaimValueConverter().convert(value);
    }

    protected Object convert(Collection collection) {
        boolean isKeyValue = !collection.isEmpty();
        for (Object value : collection) {
            isKeyValue = isKeyValue && this.isKeyValueContainer(value);
        }
        if (isKeyValue) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Object value : collection) {
                String tmpKey = this.getKey(value);
                Object tmpValue = this.convert(value);
                result.put(tmpKey, tmpValue);
            }
            return result;
        }
        return collection.stream().map(e -> this.convert(e)).toList();
    }

    protected IArgs convert(IArgs args) {
        Args result = Args.create();
        if (args.isNamed()) {
            Iterator it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = (IArgs.IBinding)it.next();
                result.put(binding.getName(), this.convert(binding.getValue()));
            }
        } else {
            IArgs.IBinding binding;
            boolean isKeyValue = args.size() != 0;
            Iterator it = args.bindings();
            while (it.hasNext()) {
                binding = (IArgs.IBinding)it.next();
                isKeyValue = isKeyValue && this.isKeyValueContainer(binding.getValue());
            }
            if (isKeyValue) {
                it = args.bindings();
                while (it.hasNext()) {
                    binding = (IArgs.IBinding)it.next();
                    String tmpKey = this.getKey(binding.getValue());
                    Object tmpValue = this.convert(binding.getValue());
                    result.put(tmpKey, tmpValue);
                }
                return result;
            }
            it = args.bindings();
            while (it.hasNext()) {
                binding = (IArgs.IBinding)it.next();
                result.add(this.convert(binding.getValue()));
            }
        }
        return result;
    }

    protected Map<String, Object> convert(Map<String, Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), this.convert(entry.getValue()));
        }
        return result;
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            return this.convert(args);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return this.convert(map);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return this.convert(collection);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return this.convert(array);
        }
        return String.valueOf(value);
    }

    protected Object convert(Object[] array) {
        boolean isKeyValue = array.length > 0;
        for (Object value : array) {
            isKeyValue = isKeyValue && this.isKeyValueContainer(value);
        }
        if (isKeyValue) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Object value : array) {
                String tmpKey = this.getKey(value);
                Object tmpValue = this.convert(value);
                result.put(tmpKey, tmpValue);
            }
            return result;
        }
        return Stream.of(array).map(e -> this.convert(e)).toList();
    }

    protected String getKey(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return (String)map.get("key");
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            return (String)args.get("key");
        }
        return null;
    }

    protected boolean isKeyValueContainer(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.containsKey("key") && (map.containsKey("value") || map.containsKey("values"));
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            return args.isDefined("key") && (args.isDefined("value") || args.isDefined("values"));
        }
        return false;
    }
}

