/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.entity.principal;

import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.model.entity.principal.IClaim;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalDao;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalProvider;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class ExplicitPrincipalProvider
implements IPrincipalProvider {
    private static final IPrincipal NULL = new IPrincipal(){

        @Override
        public IClaim getClaim(String key) {
            return null;
        }

        @Override
        public List<IClaim> getClaims() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }
    };
    private final ThreadLocal<Deque<IPrincipal>> principals = new ForwardedThreadLocal(){

        protected Object initialValue() {
            return new ArrayDeque();
        }
    };
    private String role;
    private IPrincipalDao principalDao;

    @Override
    public void enter(IOptionSupport optionSupport) {
        Deque<IPrincipal> valueHolder = this.principals.get();
        Object option = FlowOptions.getPrincipal((IOptionSupport)optionSupport);
        try {
            IPrincipal principal = (IPrincipal)this.getPrincipalDao().lookupItem(option);
            valueHolder.push(principal == null ? NULL : principal);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public IPrincipal getPrincipal() {
        Deque<IPrincipal> valueHolder = this.principals.get();
        IPrincipal value = valueHolder.peek();
        return value == NULL ? null : value;
    }

    public IPrincipalDao getPrincipalDao() {
        return this.principalDao;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @PostConstruct
    public void init() {
        if (this.getPrincipalDao() == null) {
            throw new IllegalArgumentException("principalDao required");
        }
        if (StringTools.isEmpty((String)this.getRole())) {
            throw new IllegalArgumentException("role required");
        }
    }

    @Override
    public void leave() {
        Deque<IPrincipal> valueHolder = this.principals.get();
        valueHolder.pop();
    }

    public void setPrincipalDao(IPrincipalDao principalDao) {
        this.principalDao = principalDao;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

