/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.entity.principal;

import de.intarsys.cloudsuite.gears.model.entity.common.CommonEntity;
import de.intarsys.cloudsuite.gears.model.entity.principal.GenericClaim;
import de.intarsys.cloudsuite.gears.model.entity.principal.IClaim;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenericPrincipal
extends CommonEntity
implements IPrincipal,
IStringEvaluator {
    private String name;
    private List<IClaim> claims = new ArrayList<IClaim>();
    private final IStringEvaluator resolver = new ContainerResolver(){

        protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
            if ("name".equals(expression)) {
                return GenericPrincipal.this.getName();
            }
            if ("claims".equals(expression)) {
                return new ContainerResolver(){

                    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
                        IClaim claim = GenericPrincipal.this.getClaim(expression);
                        if (claim == null) {
                            throw new EvaluationException("can't evaluate '" + expression + "'");
                        }
                        return claim.getValue();
                    }
                };
            }
            return this.notFound(expression);
        }
    };

    public void addClaim(IClaim claim) {
        this.claims.add(claim);
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.resolver.evaluate(expression, args);
    }

    @Override
    public IClaim getClaim(String key) {
        return this.claims.stream().filter(claim -> claim.getKey().equals(key)).findFirst().orElse(null);
    }

    @Override
    public List<IClaim> getClaims() {
        return this.claims;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setClaim(String property, Object value) {
        GenericClaim claim = new GenericClaim();
        claim.setKey(property);
        claim.setValue(value);
        this.addClaim(claim);
    }

    public void setClaims(List<IClaim> claims) {
        claims.forEach(claim -> this.addClaim((IClaim)claim));
    }

    public void setClaims(Map<String, IClaim> claims) {
        claims.values().forEach(claim -> this.addClaim((IClaim)claim));
    }

    public void setName(String name) {
        this.name = name;
    }

    public IArgs toArgs() {
        Args args = Args.create();
        args.put("type", (Object)this.getClass().getName());
        args.put("name", (Object)this.getName());
        return args;
    }
}

