/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.entity.principal;

import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalProvider;
import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PrincipalContext
implements IStringEvaluator {
    @Autowired(required=false)
    private List<IPrincipalProvider> principalProviders = new ArrayList<IPrincipalProvider>();
    private final IStringEvaluator resolver = new ContainerResolver(){

        protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
            return PrincipalContext.this.getPrincipal(expression);
        }
    };

    public void enter(IOptionSupport optionSupport) {
        for (IPrincipalProvider principalProvider : this.principalProviders) {
            principalProvider.enter(optionSupport);
        }
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.resolver.evaluate(expression, args);
    }

    public IPrincipal getPrincipal(String role) {
        IPrincipalProvider provider = this.getPrincipalProvider(role);
        return provider == null ? null : provider.getPrincipal();
    }

    public IPrincipalProvider getPrincipalProvider(String role) {
        if (role != null) {
            for (IPrincipalProvider provider : this.principalProviders) {
                if (!role.equals(provider.getRole())) continue;
                return provider;
            }
            String suffix = (":" + role).toLowerCase();
            for (IPrincipalProvider provider : this.principalProviders) {
                if (!provider.getRole().toLowerCase().endsWith(suffix)) continue;
                return provider;
            }
        }
        return null;
    }

    public void leave() {
        for (IPrincipalProvider principalProvider : this.principalProviders) {
            principalProvider.leave();
        }
    }
}

