/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.persistence.pojo;

import de.intarsys.cloudsuite.gears.model.entity.common.IEntity;
import de.intarsys.cloudsuite.gears.model.persistence.common.CommonEntityDao;
import de.intarsys.cloudsuite.gears.model.persistence.common.KeyToStringConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PojoEntityDao<T extends IEntity>
extends CommonEntityDao<T> {
    private Map<String, T> itemsById = new HashMap<String, T>();
    private List<T> items = new ArrayList<T>();

    public PojoEntityDao() {
        this.setKeyConverter(new KeyToStringConverter());
    }

    public List<T> getItems() {
        return this.items;
    }

    public Map<String, T> getItemsById() {
        return this.itemsById;
    }

    @Override
    public T lookupItem(Object key) throws IOException {
        if (key == null) {
            return null;
        }
        String lookupKey = String.valueOf(this.getKeyConverter().convert(key));
        return (T)((IEntity)this.itemsById.get(lookupKey));
    }

    public void setItems(List<T> principals) {
        this.items = principals;
        principals.stream().forEach(principal -> this.itemsById.put(principal.getId(), principal));
    }

    public void setItemsById(Map<String, T> principals) {
        this.itemsById = principals;
    }
}

