/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.encryption;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionAlgorithm;
import de.intarsys.cloudsuite.gears.repository.encryption.RecipientInfo;
import de.intarsys.cloudsuite.gears.repository.encryption.SymmetricRecipientInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EncryptionInfo {
    private String version = "1.0";
    private List<RecipientInfo> recipients = new ArrayList<RecipientInfo>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EncryptionAlgorithm encryptionAlgorithm;

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipientInfo getRecipientInfo(String id) {
        EncryptionInfo encryptionInfo = this;
        synchronized (encryptionInfo) {
            for (RecipientInfo info : this.getRecipients()) {
                if (!(info instanceof SymmetricRecipientInfo) || !id.equals(((SymmetricRecipientInfo)info).getKeyIdentifier())) continue;
                return info;
            }
        }
        return null;
    }

    public List<RecipientInfo> getRecipients() {
        return this.recipients;
    }

    public String getVersion() {
        return this.version;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipientInfo(String id, RecipientInfo recipientInfo) {
        EncryptionInfo encryptionInfo = this;
        synchronized (encryptionInfo) {
            Iterator<RecipientInfo> itInfo = this.getRecipients().iterator();
            while (itInfo.hasNext()) {
                RecipientInfo info = itInfo.next();
                if (!(info instanceof SymmetricRecipientInfo) || !id.equals(((SymmetricRecipientInfo)info).getKeyIdentifier())) continue;
                itInfo.remove();
            }
            this.recipients.add(recipientInfo);
        }
    }

    public void setRecipients(List<RecipientInfo> recipients) {
        this.recipients = recipients;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

