/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.encryption;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionAlgorithm;
import de.intarsys.cloudsuite.gears.repository.encryption.RecipientInfo;

public abstract class SymmetricRecipientInfo
extends RecipientInfo {
    private String keyIdentifier;
    @JsonIgnore
    private boolean transientEncryptedKey;
    private EncryptionAlgorithm encryptionAlgorithm;
    private byte[] encryptedKey;

    public byte[] getEncryptedKey() {
        return this.encryptedKey == null ? null : (byte[])this.encryptedKey.clone();
    }

    @JsonGetter(value="encryptedKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public byte[] getEncryptedKeyJson() {
        return this.transientEncryptedKey ? null : this.getEncryptedKey();
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public boolean isTransientEncryptedKey() {
        return this.transientEncryptedKey;
    }

    public void setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = (byte[])encryptedKey.clone();
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public void setTransientEncryptedKey(boolean transientEncryptedKey) {
        this.transientEncryptedKey = transientEncryptedKey;
    }
}

