/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.fs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.api.IRepositorySession;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionAlgorithm;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionInfo;
import de.intarsys.cloudsuite.gears.repository.encryption.PlainKeyRecipientInfo;
import de.intarsys.cloudsuite.gears.repository.encryption.RecipientInfo;
import de.intarsys.cloudsuite.gears.repository.encryption.SharedKeyRecipientInfo;
import de.intarsys.cloudsuite.gears.repository.encryption.SymmetricEncryptionAlgorithm;
import de.intarsys.cloudsuite.gears.repository.encryption.SymmetricRecipientInfo;
import de.intarsys.cloudsuite.gears.repository.fs.FSRepositoryLocator;
import de.intarsys.cloudsuite.gears.repository.impl.CommonRepositoryDao;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemMetadata;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemProperties;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.cloudsuite.gears.repository.standard.StandardRepository;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.bytes.StaticByteProvider;
import de.intarsys.tools.crypto.standard.CTREncryptedRandomAccess;
import de.intarsys.tools.crypto.standard.NullCipherFactory;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessFile;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRepositoryDao
extends CommonRepositoryDao {
    private static final String ENCRYPTION_ALGO = "AES";
    private static final int IV_15 = 15;
    private static final int IV_14 = 14;
    private static final int IV_13 = 13;
    private static final int IV_12 = 12;
    private static final String PATH_REPO = "repository";
    public static final String NAME_META = ".meta";
    public static final String NAME_PROPS = ".props";
    public static final String NAME_STREAM = ".stream";
    public static final String NAME_TEMP = ".temp";
    public static final String KEY_ID_REPOSITORY = "urn:intarsys:repository:1.0:keyid:Standard";
    private static final Logger Log = LoggerFactory.getLogger(FSRepositoryDao.class);
    private static final Attribute ATTR_KEK_PARAM = new Attribute("kekParam");
    private String baseDir;
    private ObjectMapper mapper;
    private ICipherFactory contentCipherFactory = new NullCipherFactory();
    private ICipherFactory keyWrapperFactory = new NullCipherFactory();
    private final IByteProvider restrictedIdentificationProvider = new RestrictedIdentificationProvider();

    @Override
    public void clear(StandardRepository standardRepository) throws IOException {
        try {
            FileTools.deleteRecursivly((File)this.getRepoDir(), (boolean)false);
        }
        catch (IOException e) {
            Log.warn("cannot clear repository at {}", (Object)this.getRepoDir(), (Object)e);
        }
    }

    protected void clearIvCounter(SecretKeyParameter cek) {
        cek.getIv()[12] = 0;
        cek.getIv()[13] = 0;
        cek.getIv()[14] = 0;
        cek.getIv()[15] = 0;
    }

    protected SecretKeyParameter createCekParameter(FSRepositoryLocator locator) throws IOException, GeneralSecurityException {
        RepositoryItemMetadata metadata = locator.getItem().getMetadata();
        SecretKeyParameter kekParam = (SecretKeyParameter)locator.getKekParameter();
        SecretKeyParameter cekParam = this.createCekParameter(metadata, (ICipherParameter)kekParam);
        return cekParam;
    }

    protected SecretKeyParameter createCekParameter(RepositoryItemMetadata metadata, ICipherParameter kekParam) throws GeneralSecurityException {
        EncryptionInfo encryptionInfos = metadata.getEncryptionInfo();
        if (encryptionInfos == null) {
            return null;
        }
        EncryptionAlgorithm contentEncAlgo = encryptionInfos.getEncryptionAlgorithm();
        if (contentEncAlgo == null) {
            return null;
        }
        if (contentEncAlgo instanceof SymmetricEncryptionAlgorithm) {
            byte[] contentEncryptionIv = ((SymmetricEncryptionAlgorithm)contentEncAlgo).getIv();
            RecipientInfo recipientInfo = encryptionInfos.getRecipientInfo(KEY_ID_REPOSITORY);
            if (recipientInfo == null) {
                return null;
            }
            if (recipientInfo instanceof PlainKeyRecipientInfo) {
                byte[] key = ((SymmetricRecipientInfo)recipientInfo).getEncryptedKey();
                return new SecretKeyParameter(contentEncryptionIv, key);
            }
            if (recipientInfo instanceof SharedKeyRecipientInfo) {
                try {
                    ICipherParameter tmpKekParam = kekParam == null ? this.createKekParameter() : kekParam;
                    byte[] keyEncKey = ((SecretKeyParameter)tmpKekParam).getKey();
                    EncryptionAlgorithm keyEncAlgo = ((SymmetricRecipientInfo)recipientInfo).getEncryptionAlgorithm();
                    byte[] keyEncIv = ((SymmetricEncryptionAlgorithm)keyEncAlgo).getIv();
                    byte[] encryptedKey = ((SymmetricRecipientInfo)recipientInfo).getEncryptedKey();
                    SecretKeyParameter keyEncParam = new SecretKeyParameter(keyEncIv, keyEncKey);
                    Cipher keyWrapper = this.getKeyWrapperFactory().createUnwrap((ICipherParameter)keyEncParam);
                    Key jcaKey = keyWrapper.unwrap(encryptedKey, ENCRYPTION_ALGO, 3);
                    return new SecretKeyParameter(contentEncryptionIv, jcaKey.getEncoded());
                }
                catch (IOException e) {
                    throw new InvalidKeyException(e);
                }
            }
            throw new GeneralSecurityException("recipient " + recipientInfo.getType() + " not supported");
        }
        throw new GeneralSecurityException("encryption " + contentEncAlgo.getType() + " not supported");
    }

    protected SecretKeyParameter createCekParameterInitial() {
        return new SecretKeyParameter(ByteArrayTools.createRandomBytes((int)this.getContentCipherFactory().getBlockSize()), ByteArrayTools.createRandomBytes((int)this.getContentCipherFactory().getKeySize()));
    }

    protected InputStream createContentInputStream(FSRepositoryLocator locator) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(locator.getStreamFile());
            SecretKeyParameter cekParam = this.createCekParameter(locator);
            if (cekParam == null) {
                if (this.isEncrypted()) {
                    throw new GeneralSecurityException("encryption required");
                }
                return is;
            }
            this.clearIvCounter(cekParam);
            Cipher cipher = this.getContentCipherFactory().createDecipher((ICipherParameter)cekParam);
            return new CipherInputStream(is, cipher);
        }
        catch (FileNotFoundException e) {
            StreamTools.close(is);
            return new ByteArrayInputStream(new byte[0]);
        }
        catch (GeneralSecurityException e) {
            StreamTools.close(is);
            throw new IOException("decryption initialization failed", e);
        }
    }

    protected OutputStream createContentOutputStream(FSRepositoryLocator locator) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(locator.getStreamFile());
            SecretKeyParameter cekParam = this.createCekParameter(locator);
            if (cekParam == null) {
                return os;
            }
            this.clearIvCounter(cekParam);
            Cipher cipher = this.getContentCipherFactory().createEncipher((ICipherParameter)cekParam);
            return new CipherOutputStream(os, cipher);
        }
        catch (IOException e) {
            StreamTools.close(os);
            throw e;
        }
        catch (Exception e) {
            StreamTools.close(os);
            throw new IOException("encryption initialization failed", e);
        }
    }

    protected IRandomAccess createContentRandomAccess(FSRepositoryLocator locator) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(locator.getStreamFile());
            SecretKeyParameter cekParam = this.createCekParameter(locator);
            if (cekParam == null) {
                return raf;
            }
            StaticByteProvider ivProvider = new StaticByteProvider(cekParam.getIv());
            StaticByteProvider keyProvider = new StaticByteProvider(cekParam.getKey());
            return new CTREncryptedRandomAccess((IRandomAccess)raf, this.getContentCipherFactory(), (IByteProvider)ivProvider, (IByteProvider)keyProvider);
        }
        catch (GeneralSecurityException e) {
            StreamTools.close(raf);
            throw new IOException(e);
        }
    }

    @Override
    public RepositoryDocument createDocument(RepositoryFolder parent, String name) throws IOException {
        String id = this.createItemId();
        return this.createDocument(parent, id, name);
    }

    protected RepositoryDocument createDocument(RepositoryFolder parent, String id, String name) throws IOException {
        String tempName = StringTools.isEmpty((String)name) ? id : name;
        File docFile = this.createFileDocument(parent, id);
        RepositoryItemMetadata metadata = RepositoryItemMetadata.createDocument();
        RepositoryDocument repoDoc = this.createDocument(parent, id, metadata, docFile);
        metadata.setName(tempName);
        try {
            this.encrypt(repoDoc, null, (ICipherParameter)this.createKekParameter());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("document encryption failed", e);
        }
        return repoDoc;
    }

    protected EncryptionInfo createEncryptionInfo(SecretKeyParameter cekParam) {
        EncryptionInfo result = new EncryptionInfo();
        SymmetricEncryptionAlgorithm encryptionAlgorithm = new SymmetricEncryptionAlgorithm();
        encryptionAlgorithm.setAlgorithmName(this.getContentCipherFactory().getEncryptionAlgorithmTransformation());
        encryptionAlgorithm.setIv(cekParam.getIv());
        result.setEncryptionAlgorithm(encryptionAlgorithm);
        return result;
    }

    protected File createFileDocument(RepositoryFolder repoParent, String id) throws IOException {
        File result = this.createFileRaw(repoParent, id);
        FileTools.mkdirs((File)result);
        return result;
    }

    protected File createFileFolder(RepositoryFolder repoParent, String id) throws IOException {
        File result = this.createFileRaw(repoParent, id);
        FileTools.mkdirs((File)result);
        return result;
    }

    protected File createFileMeta(RepositoryFolder repoParent, String id) {
        return this.createFileRaw(repoParent, id + "/.meta");
    }

    protected File createFileMeta(RepositoryItem repoItem) {
        return this.createFileRaw(repoItem, NAME_META);
    }

    protected File createFileproperties(RepositoryItem repoItem) {
        return this.createFileRaw(repoItem, NAME_PROPS);
    }

    protected File createFileRaw(RepositoryItem repoItem, String name) {
        File fileParent = this.getImpl(repoItem);
        return new File(fileParent, name);
    }

    protected File createFileStream(RepositoryFolder repoParent, String id) {
        return this.createFileRaw(repoParent, id + "/.stream");
    }

    protected File createFileStream(RepositoryItem item) {
        return this.createFileRaw(item, NAME_STREAM);
    }

    @Override
    public RepositoryFolder createFolder(RepositoryFolder parent, String name) throws IOException {
        String id = this.createItemId();
        return this.createFolder(parent, id, name);
    }

    protected RepositoryFolder createFolder(RepositoryFolder parent, String id, String name) throws IOException {
        String tempName = StringTools.isEmpty((String)name) ? id : name;
        File folderDir = this.createFileFolder(parent, id);
        RepositoryItemMetadata metadata = RepositoryItemMetadata.createFolder();
        RepositoryFolder repoFolder = this.createFolder(parent, id, metadata, folderDir);
        metadata.setName(tempName);
        return repoFolder;
    }

    protected String createItemId() {
        return UUID.randomUUID().toString();
    }

    protected SecretKeyParameter createKekParameter() throws IOException {
        return new SecretKeyParameter(null, this.restrictedIdentificationProvider.getBytes());
    }

    protected RecipientInfo createRecipientInfo(ICipherParameter cekParam, ICipherParameter kekParam) throws GeneralSecurityException {
        if (!this.isEncrypted()) {
            return null;
        }
        if (this.getKeyWrapperFactory() == null || this.getKeyWrapperFactory() instanceof NullCipherFactory) {
            PlainKeyRecipientInfo recipientInfo = new PlainKeyRecipientInfo();
            recipientInfo.setEncryptedKey(((SecretKeyParameter)cekParam).getKey());
            recipientInfo.setKeyIdentifier(KEY_ID_REPOSITORY);
            return recipientInfo;
        }
        try {
            ICipherParameter tmpKekParam = kekParam == null ? this.createKekParameter() : kekParam;
            Cipher keyWrapper = this.getKeyWrapperFactory().createWrap(tmpKekParam);
            SecretKeySpec jcaKey = new SecretKeySpec(((SecretKeyParameter)cekParam).getKey(), ENCRYPTION_ALGO);
            byte[] encryptedCek = keyWrapper.wrap(jcaKey);
            SharedKeyRecipientInfo recipientInfo = new SharedKeyRecipientInfo();
            SymmetricEncryptionAlgorithm encAlg = new SymmetricEncryptionAlgorithm();
            encAlg.setIv(keyWrapper.getIV());
            encAlg.setAlgorithmName(this.getKeyWrapperFactory().getEncryptionAlgorithmTransformation());
            recipientInfo.setEncryptionAlgorithm(encAlg);
            recipientInfo.setEncryptedKey(encryptedCek);
            recipientInfo.setKeyIdentifier(KEY_ID_REPOSITORY);
            return recipientInfo;
        }
        catch (IOException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    public void delete(RepositoryItem repoItem) throws IOException {
        File file = this.getImpl(repoItem);
        FileTools.deleteRecursivly((File)file);
    }

    @Override
    public void encrypt(RepositoryItem item, ICipherParameter oldKekParam, ICipherParameter kekParam) throws GeneralSecurityException, IOException {
        RepositoryItemMetadata metadata = item.getMetadata();
        SecretKeyParameter cekParam = this.createCekParameter(metadata, oldKekParam);
        if (cekParam == null) {
            cekParam = this.createCekParameterInitial();
        }
        EncryptionInfo encryptionInfo = null;
        RecipientInfo newRecipientInfo = this.createRecipientInfo((ICipherParameter)cekParam, kekParam);
        if (newRecipientInfo != null) {
            encryptionInfo = metadata.getEncryptionInfo();
            if (encryptionInfo == null) {
                encryptionInfo = this.createEncryptionInfo(cekParam);
            }
            encryptionInfo.setRecipientInfo(KEY_ID_REPOSITORY, newRecipientInfo);
        }
        metadata.setEncryptionInfo(encryptionInfo);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public ICipherFactory getContentCipherFactory() {
        return this.contentCipherFactory;
    }

    @Override
    public File getImpl(RepositoryItem repoItem) {
        return (File)super.getImpl(repoItem);
    }

    @Override
    public List<RepositoryItem> getItems(RepositoryFolder repoItem) throws IOException {
        File repoFile = this.getImpl(repoItem);
        File[] children = repoFile.listFiles(file -> file.isDirectory());
        ArrayList<RepositoryItem> result = new ArrayList<RepositoryItem>();
        if (children != null) {
            for (File childRepoFile : children) {
                String id = FileTools.getBaseName((File)childRepoFile);
                try {
                    result.add(this.readItem(repoItem, id, childRepoFile));
                }
                catch (Exception e) {
                    Log.debug("{} folder '{}' item '{}' failed ({})", new Object[]{this, repoItem.getId(), id, ExceptionTools.getMessage((Throwable)e)});
                }
            }
        }
        return result;
    }

    protected SecretKeyParameter getKekParam(IRepositorySession session) {
        SecretKeyParameter kekParam = (SecretKeyParameter)session.getAttribute(ATTR_KEK_PARAM);
        return kekParam;
    }

    public ICipherFactory getKeyWrapperFactory() {
        return this.keyWrapperFactory;
    }

    @Override
    public ILocator getLocator(RepositoryItem repoItem) throws IOException {
        return new FSRepositoryLocator(this, repoItem.getRepository(), repoItem.getPath(), repoItem.getMetadata().getName(), (ICipherParameter)this.createKekParameter(), repoItem);
    }

    protected File getRepoDir() throws IOException {
        File repoDir = new File(this.getBaseDir(), PATH_REPO);
        FileTools.mkdirs((File)repoDir);
        return repoDir;
    }

    @Override
    public RepositoryFolder getRootFolder(IRepository repository) throws IOException {
        RepositoryItemMetadata metadata = RepositoryItemMetadata.createFolder();
        RepositoryFolder result = RepositoryFolder.createNew(repository, null, "", metadata, this, this.getRepoDir());
        metadata.setName("root");
        return result;
    }

    @PostConstruct
    public void init() {
        if (StringTools.isEmpty((String)this.baseDir)) {
            this.baseDir = System.getProperty("user.home") + "/cloudsuite";
        }
        this.mapper = new ObjectMapper();
    }

    protected boolean isEncrypted() {
        return this.getContentCipherFactory() != null && !(this.getContentCipherFactory() instanceof NullCipherFactory);
    }

    protected RepositoryItem readItem(RepositoryFolder parent, String id, File repoFile) throws IOException {
        RepositoryItemMetadata metadata = this.readItemMetadata(parent, id);
        if (metadata.isFolder()) {
            return RepositoryFolder.createFromDao(parent.getRepository(), parent, id, metadata, this, repoFile);
        }
        if (metadata.isDocument()) {
            return RepositoryDocument.createFromDao(parent.getRepository(), parent, id, metadata, this, repoFile);
        }
        throw new IOException("unsupported item type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepositoryItemMetadata readItemMetadata(RepositoryFolder repoFolder, String id) throws JsonParseException, JsonMappingException, IOException {
        File metaFile = this.createFileMeta(repoFolder, id);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(metaFile));
        try {
            RepositoryItemMetadata repositoryItemMetadata = (RepositoryItemMetadata)this.mapper.readValue((InputStream)is, RepositoryItemMetadata.class);
            return repositoryItemMetadata;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setContentCipherFactory(ICipherFactory cipherFactory) {
        this.contentCipherFactory = cipherFactory;
    }

    public void setKeyWrapperFactory(ICipherFactory keyWrapper) {
        this.keyWrapperFactory = keyWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItemMetadata(RepositoryItemMetadata metadata) throws IOException {
        File metaFile = this.createFileMeta(metadata.getItem());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(metaFile));
        try {
            this.mapper.writeValue((OutputStream)os, (Object)metadata);
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItemProperties(RepositoryItemProperties properties) throws IOException {
        File file = this.createFileMeta(properties.getItem());
        if (properties.getProperties() == null || properties.getProperties().size() == 0) {
            FileTools.delete((File)file);
            return;
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.mapper.writeValue((OutputStream)os, (Object)properties);
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }
}

