/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.fs;

import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.fs.FSRepositoryDao;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsSupport;
import de.intarsys.tools.locator.AbstractLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRepositoryLocator
extends AbstractLocator
implements IArgsSupport,
IMimeTypeSupport {
    private static final Logger Log = LoggerFactory.getLogger(FSRepositoryLocator.class);
    private final String repoPath;
    private final String path;
    private final IRepository repository;
    private final FSRepositoryDao dao;
    private final ICipherParameter kekParameter;
    private RepositoryItem item;

    public FSRepositoryLocator(FSRepositoryDao dao, IRepository repository, String repoPath, String path, ICipherParameter kekParameter, RepositoryItem item) {
        this.dao = dao;
        this.repository = repository;
        this.repoPath = repoPath;
        this.path = path;
        this.kekParameter = kekParameter;
        this.item = item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepositoryItem basicGetItem() {
        FSRepositoryLocator fSRepositoryLocator = this;
        synchronized (fSRepositoryLocator) {
            return this.item;
        }
    }

    public void delete() throws IOException {
        FileTools.deleteRecursivly((File)this.getFile(), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpBytes(byte[] pBytes) throws IOException {
        ByteArrayInputStream is = null;
        OutputStream os = null;
        try {
            is = new ByteArrayInputStream(pBytes);
            os = this.getOutputStream();
            StreamTools.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close((Closeable)is);
        StreamTools.close((Closeable)os);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FSRepositoryLocator)) {
            return false;
        }
        return this.getRepository() == ((FSRepositoryLocator)((Object)obj)).getRepository() && this.getRepoPath().equals(((FSRepositoryLocator)((Object)obj)).getRepoPath());
    }

    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public IArgs getArgs() {
        try {
            return this.getItem().getProperties().getProperties();
        }
        catch (IOException e) {
            return Args.create();
        }
    }

    protected byte[] getBytes() throws IOException {
        return StreamTools.getBytes((InputStream)this.getInputStream());
    }

    public ILocator getChild(String name) {
        String childPath = PathTools.join((String[])new String[]{this.getPath(), name});
        try {
            RepositoryItem repoItem = this.getItem();
            if (!repoItem.isDocument()) {
                RepositoryFolder repoFolder = (RepositoryFolder)repoItem;
                for (RepositoryItem childRepoItem : repoFolder.getItems()) {
                    if (!childRepoItem.getMetadata().getName().equals(name)) continue;
                    return new FSRepositoryLocator(this.dao, this.getRepository(), childRepoItem.getPath(), childPath, this.getKekParameter(), childRepoItem);
                }
            }
        }
        catch (IOException e) {
            Log.debug("{} file '{}' not found", (Object)this, (Object)name);
        }
        String childRepoPath = PathTools.join((String[])new String[]{this.getRepoPath(), this.dao.createItemId()});
        return new FSRepositoryLocator(this.dao, this.getRepository(), childRepoPath, childPath, this.getKekParameter(), null);
    }

    public String getContentType() {
        RepositoryItem tmpItem = this.basicGetItem();
        if (tmpItem == null) {
            return null;
        }
        return tmpItem.getMetadata().getContentType();
    }

    protected File getFile() throws IOException {
        return this.dao.getImpl(this.getItem());
    }

    public InputStream getInputStream() throws IOException {
        return this.dao.createContentInputStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryItem getItem() throws IOException {
        FSRepositoryLocator fSRepositoryLocator = this;
        synchronized (fSRepositoryLocator) {
            if (this.item == null) {
                this.item = this.getRepository().lookupItem(this.getRepoPath());
            }
            return this.item;
        }
    }

    public ICipherParameter getKekParameter() {
        return this.kekParameter;
    }

    public long getLength() throws IOException {
        return this.getStreamFile().length();
    }

    public String getName() {
        return PathTools.getName((String)this.path);
    }

    public OutputStream getOutputStream() throws IOException {
        this.realizeDocument();
        FileTools.mkdirs((File)this.getFile());
        return this.dao.createContentOutputStream(this);
    }

    public FSRepositoryLocator getParent() {
        if (StringTools.isEmpty((String)this.getRepoPath())) {
            return null;
        }
        RepositoryFolder parentItem = this.basicGetItem() == null ? null : this.basicGetItem().getParent();
        String parentRepoPath = PathTools.getParent((String)this.getRepoPath());
        String parentPath = PathTools.getParent((String)this.getPath());
        return new FSRepositoryLocator(this.dao, this.getRepository(), parentRepoPath, parentPath, this.getKekParameter(), parentItem);
    }

    public String getPath() {
        return this.path;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        this.realizeDocument();
        FileTools.mkdirs((File)this.getFile());
        return this.dao.createContentRandomAccess(this);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public Reader getReader(String charset) throws IOException {
        if (StringTools.isEmpty((String)charset)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), charset);
    }

    protected String getRepoPath() {
        return this.repoPath;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    protected File getStreamFile() throws IOException {
        return this.dao.createFileStream(this.getItem());
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String charset) throws IOException {
        if (StringTools.isEmpty((String)charset)) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), charset);
    }

    public int hashCode() {
        return this.getRepoPath().hashCode();
    }

    public boolean isDirectory() {
        try {
            return this.getItem().isFolder();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        try {
            RepositoryItem repoItem = this.getItem();
            if (!repoItem.isDocument()) {
                ArrayList<FSRepositoryLocator> result = new ArrayList<FSRepositoryLocator>();
                RepositoryFolder repoFolder = (RepositoryFolder)repoItem;
                for (RepositoryItem childRepoItem : repoFolder.getItems()) {
                    if (filter != null && !filter.accept((ILocator)this, childRepoItem.getMetadata().getName())) continue;
                    String childPath = PathTools.join((String[])new String[]{this.getPath(), childRepoItem.getMetadata().getName()});
                    result.add(new FSRepositoryLocator(this.dao, this.getRepository(), childRepoItem.getPath(), childPath, this.getKekParameter(), childRepoItem));
                }
                return result.toArray(new ILocator[result.size()]);
            }
        }
        catch (IOException e) {
            Log.warn("{} cannot read children", (Object)this, (Object)e);
        }
        return new FSRepositoryLocator[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepositoryDocument realizeDocument() throws IOException {
        try {
            return (RepositoryDocument)this.getItem();
        }
        catch (FileNotFoundException e) {
            FSRepositoryLocator fSRepositoryLocator = this;
            synchronized (fSRepositoryLocator) {
                RepositoryFolder parentRepoFolder = this.getParent().realizeFolder();
                String id = PathTools.getName((String)this.getRepoPath());
                String name = this.getName();
                this.item = this.dao.createDocument(parentRepoFolder, id, name);
                return (RepositoryDocument)this.item;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RepositoryFolder realizeFolder() throws IOException {
        try {
            return (RepositoryFolder)this.getItem();
        }
        catch (FileNotFoundException e) {
            RepositoryFolder parentRepoFolder = this.getParent().realizeFolder();
            String id = PathTools.getName((String)this.getRepoPath());
            String name = this.getName();
            FSRepositoryLocator fSRepositoryLocator = this;
            synchronized (fSRepositoryLocator) {
                this.item = this.dao.createFolder(parentRepoFolder, id, name);
                return (RepositoryFolder)this.item;
            }
        }
    }

    public void rename(String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void synch() {
    }

    public String toString() {
        return this.getRepoPath();
    }

    public URI toURI() {
        return this.getRepository().getURI().resolve(this.getRepoPath());
    }
}

