/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.impl;

import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.api.IRepositoryDao;
import de.intarsys.cloudsuite.gears.repository.api.IRepositoryItemVisitor;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemMetadata;
import de.intarsys.tools.string.StringTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class RepositoryFolder
extends RepositoryItem {
    private List<RepositoryItem> items;

    public static RepositoryFolder createFromDao(IRepository repository, RepositoryFolder parent, String id, RepositoryItemMetadata metadata, IRepositoryDao repositoryDao, Object impl) throws IOException {
        return new RepositoryFolder(repository, parent, id, metadata, repositoryDao, impl);
    }

    public static RepositoryFolder createNew(IRepository repository, RepositoryFolder parent, String id, RepositoryItemMetadata metadata, IRepositoryDao repositoryDao, Object impl) throws IOException {
        RepositoryFolder result = new RepositoryFolder(repository, parent, id, metadata, repositoryDao, impl);
        if (parent != null) {
            parent.addItem(result);
        }
        return result;
    }

    protected RepositoryFolder(IRepository repository, RepositoryFolder parent, String id, RepositoryItemMetadata metadata, IRepositoryDao repositoryDao, Object impl) throws IOException {
        super(repository, parent, id, metadata, repositoryDao, impl);
    }

    protected void addItem(RepositoryItem item) throws IOException {
        if (this.isRoot()) {
            return;
        }
        this.getItems().add(item);
    }

    public RepositoryDocument createDocument(String name) throws IOException {
        return this.getRepositoryDao().createDocument(this, name);
    }

    public RepositoryFolder createFolder(String name) throws IOException {
        return this.getRepositoryDao().createFolder(this, name);
    }

    @Override
    public void forEachTree(IRepositoryItemVisitor visitor) throws IOException {
        visitor.accept(this);
        for (RepositoryItem item : this.getItems()) {
            item.forEachTree(visitor);
        }
    }

    public List<RepositoryDocument> getDocuments() throws IOException {
        return this.getItems().stream().filter(item -> item.isDocument()).map(item -> (RepositoryDocument)item).collect(Collectors.toList());
    }

    public List<RepositoryFolder> getFolders() throws IOException {
        return this.getItems().stream().filter(item -> item.isFolder()).map(item -> (RepositoryFolder)item).collect(Collectors.toList());
    }

    public RepositoryItem getItem(String segment) throws IOException {
        if (StringTools.isEmpty((String)segment)) {
            throw new IOException("invalid segment, may not be empty");
        }
        for (RepositoryItem item : this.getItems()) {
            if (!item.getId().equals(segment)) continue;
            return item;
        }
        throw new FileNotFoundException("item '" + segment + "' not found");
    }

    public List<RepositoryItem> getItems() throws IOException {
        if (this.items == null) {
            List<RepositoryItem> tmpItems = this.getRepositoryDao().getItems(this);
            if (this.isRoot()) {
                return tmpItems;
            }
            this.items = tmpItems;
        }
        return this.items;
    }

    @Override
    public boolean isDocument() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    protected void remove(RepositoryItem repositoryItem) {
        if (this.items == null) {
            return;
        }
        this.items.remove(repositoryItem);
    }

    public String toString() {
        return "RepositoryFolder " + this.getId();
    }
}

