/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.impl;

import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.api.IRepositoryDao;
import de.intarsys.cloudsuite.gears.repository.api.IRepositoryItemVisitor;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemMetadata;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemProperties;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;

public abstract class RepositoryItem
implements ILocatorSupport {
    public static final String EXT_META = ".meta";
    public static final String EXT_STREAM = ".stream";
    private final IRepositoryDao repositoryDao;
    private final RepositoryFolder parent;
    private final IRepository repository;
    private final String id;
    private final RepositoryItemMetadata metadata;
    private final RepositoryItemProperties properties;
    private final Object impl;

    protected RepositoryItem(IRepository repository, RepositoryFolder parent, String id, RepositoryItemMetadata metadata, IRepositoryDao repositoryDao, Object impl) throws IOException {
        this.repository = repository;
        this.parent = parent;
        this.id = id;
        this.metadata = metadata;
        this.metadata.setItem(this);
        this.properties = new RepositoryItemProperties();
        this.properties.setItem(this);
        this.repositoryDao = repositoryDao;
        this.impl = impl;
    }

    public void delete() throws IOException {
        this.getRepositoryDao().delete(this);
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public void encrypt(ICipherParameter oldKey, ICipherParameter newKey) throws GeneralSecurityException, IOException {
        this.getRepositoryDao().encrypt(this, oldKey, newKey);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepositoryItem) {
            return this.getPath().equals(((RepositoryItem)obj).getPath());
        }
        return super.equals(obj);
    }

    public abstract void forEachTree(IRepositoryItemVisitor var1) throws IOException;

    public String getId() {
        return this.id;
    }

    protected Object getImpl() {
        return this.impl;
    }

    public ILocator getLocator() {
        try {
            return this.getRepositoryDao().getLocator(this);
        }
        catch (IOException e) {
            throw new TunnelingException((Throwable)e);
        }
    }

    public RepositoryItemMetadata getMetadata() {
        return this.metadata;
    }

    public RepositoryFolder getParent() {
        return this.parent;
    }

    public String getPath() {
        if (this.getParent() != null && !this.getParent().isRoot()) {
            return this.getParent().getPath() + "/" + this.getId();
        }
        return this.getId();
    }

    public RepositoryItemProperties getProperties() {
        return this.properties;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public IRepositoryDao getRepositoryDao() {
        return this.repositoryDao;
    }

    public URI getURI() {
        return this.getRepository().getURI().resolve(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public abstract boolean isDocument();

    public abstract boolean isFolder();
}

