/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionInfo;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.content.IMimeTypeAccess;
import java.io.IOException;

public class RepositoryItemMetadata
implements ICharsetAccess,
IMimeTypeAccess {
    public static final String TYPE_FOLDER = "f";
    public static final String TYPE_DOCUMENT = "d";
    @JsonIgnore
    private RepositoryItem item;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EncryptionInfo encryptionInfo;
    private String type;
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String charset;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String contentType;

    public static RepositoryItemMetadata createDocument() {
        RepositoryItemMetadata result = new RepositoryItemMetadata();
        result.setType(TYPE_DOCUMENT);
        return result;
    }

    public static RepositoryItemMetadata createFolder() {
        RepositoryItemMetadata result = new RepositoryItemMetadata();
        result.setType(TYPE_FOLDER);
        return result;
    }

    @JsonSetter(value="encryptionInfo")
    public void basicSetEncryptionInfo(EncryptionInfo encryptionInfo) {
        this.encryptionInfo = encryptionInfo;
    }

    @JsonSetter(value="name")
    public void basicSetName(String name) {
        this.name = name;
    }

    protected void changed() throws IOException {
        this.getItem().getRepositoryDao().writeItemMetadata(this);
    }

    public String getCharset() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.encryptionInfo;
    }

    public RepositoryItem getItem() {
        return this.item;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isDocument() {
        return TYPE_DOCUMENT.equals(this.type);
    }

    @JsonIgnore
    public boolean isFolder() {
        return TYPE_FOLDER.equals(this.type);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setEncryptionInfo(EncryptionInfo encryptionInfo) throws IOException {
        this.basicSetEncryptionInfo(encryptionInfo);
        this.changed();
    }

    public void setItem(RepositoryItem item) {
        this.item = item;
    }

    public void setName(String name) throws IOException {
        this.basicSetName(name);
        this.changed();
    }

    public void setType(String type) {
        this.type = type;
    }
}

