/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.impl;

import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.GeneralSecurityException;

public final class RepositoryTools {
    private static RepositoryDocument createDocument(IRepository repo, TransportDocument transportDocument) throws IOException {
        return RepositoryTools.importDocument(repo.getRootFolder(), transportDocument);
    }

    private static RepositoryFolder createFolder(IRepository repo, TransportFolder transportFolder) throws IOException {
        return RepositoryTools.importFolder(repo.getRootFolder(), transportFolder);
    }

    public static RepositoryItem createItem(IRepository repo, TransportItem transportItem) throws IOException {
        if (transportItem.isDocument()) {
            return RepositoryTools.createDocument(repo, (TransportDocument)transportItem);
        }
        if (transportItem.isFolder()) {
            return RepositoryTools.createFolder(repo, (TransportFolder)transportItem);
        }
        throw new IllegalArgumentException("unsupported transport item");
    }

    public static void encrypt(RepositoryItem repoItem, ICipherParameter oldKey, ICipherParameter newKey) throws GeneralSecurityException, IOException {
        if (repoItem.isDocument()) {
            repoItem.encrypt(oldKey, newKey);
        } else {
            for (RepositoryItem childRepoItem : ((RepositoryFolder)repoItem).getItems()) {
                RepositoryTools.encrypt(childRepoItem, oldKey, newKey);
            }
            repoItem.encrypt(oldKey, newKey);
        }
    }

    private static TransportItem exportItem(RepositoryItem repoItem, IFieldSetter setter) throws IOException {
        if (repoItem.isDocument()) {
            TransportDocument transportDoc = new TransportDocument();
            transportDoc.setName(repoItem.getMetadata().getName());
            setter.setValue((TransportItem)transportDoc, repoItem.getLocator());
            transportDoc.addProperties(repoItem.getProperties().getProperties());
            return transportDoc;
        }
        TransportFolder transportFolder = new TransportFolder();
        transportFolder.setName(repoItem.getMetadata().getName());
        setter.setValue((TransportItem)transportFolder, repoItem.getLocator());
        for (RepositoryItem childRepoItem : ((RepositoryFolder)repoItem).getItems()) {
            transportFolder.addItem(RepositoryTools.exportItem(childRepoItem, setter));
        }
        transportFolder.addProperties(repoItem.getProperties().getProperties());
        return transportFolder;
    }

    public static TransportItem exportItemContent(RepositoryItem repoItem) throws IOException {
        return RepositoryTools.exportItem(repoItem, (item, locator) -> item.setContent(locator));
    }

    public static TransportItem exportItemHandle(RepositoryItem repoItem) throws IOException {
        return RepositoryTools.exportItem(repoItem, (item, locator) -> item.setHandle(locator));
    }

    public static TransportItem exportItemReference(RepositoryItem repoItem) throws IOException {
        return RepositoryTools.exportItem(repoItem, (item, locator) -> item.setPath(locator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RepositoryDocument importDocument(RepositoryFolder parent, TransportDocument transportDocument) throws IOException {
        RepositoryDocument repositoryDocument;
        ILocator locator = transportDocument.getHandle();
        if (locator != null) {
            RepositoryItem repoItem = parent.getRepository().lookupItem(locator.getPath());
            if (repoItem != null && repoItem.isDocument()) {
                return (RepositoryDocument)repoItem;
            }
            throw new IllegalArgumentException("invalid document");
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            if (transportDocument.getLocator() == null) {
                throw new IllegalArgumentException("invalid document");
            }
            is = transportDocument.getLocator().getInputStream();
            String clientName = transportDocument.getName();
            RepositoryDocument repoDoc = parent.createDocument(clientName);
            if (transportDocument.getContentType() != null) {
                repoDoc.getMetadata().setContentType(transportDocument.getContentType());
            }
            os = repoDoc.getLocator().getOutputStream();
            StreamTools.copy((InputStream)is, (OutputStream)os);
            repositoryDocument = repoDoc;
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close((Closeable)is);
        StreamTools.close((Closeable)os);
        return repositoryDocument;
    }

    private static RepositoryFolder importFolder(RepositoryFolder parent, TransportFolder transportFolder) throws IOException {
        ILocator locator = transportFolder.getHandle();
        if (locator != null) {
            RepositoryItem repoItem = parent.getRepository().lookupItem(locator.getPath());
            if (repoItem != null && repoItem.isFolder()) {
                return (RepositoryFolder)repoItem;
            }
            throw new IllegalArgumentException("invalid document");
        }
        RepositoryFolder repoFolder = parent.createFolder(transportFolder.getName());
        for (TransportItem childItem : transportFolder.getItems()) {
            RepositoryTools.importItem(repoFolder, childItem);
        }
        return repoFolder;
    }

    public static RepositoryItem importItem(RepositoryFolder parent, TransportItem transportItem) throws IOException {
        if (transportItem.isDocument()) {
            return RepositoryTools.importDocument(parent, (TransportDocument)transportItem);
        }
        if (transportItem.isFolder()) {
            return RepositoryTools.importFolder(parent, (TransportFolder)transportItem);
        }
        throw new IllegalArgumentException("unsupported transport item");
    }

    public static boolean isAncestor(RepositoryItem ancestor, RepositoryItem descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return true;
        }
        return RepositoryTools.isAncestor(ancestor, descendant.getParent());
    }

    public static RepositoryItem resolveUri(IRepository repo, String repoUrl) throws IOException {
        URI repoUri;
        try {
            repoUri = new URI(repoUrl);
        }
        catch (Exception e) {
            throw new IOException("malformed URI " + repoUrl, e);
        }
        if (!"repo".equals(repoUri.getScheme())) {
            throw new IOException("unsupported scheme " + repoUri.getScheme());
        }
        if (!"main".equals(repoUri.getHost())) {
            throw new IOException("unsupported host " + repoUri.getHost());
        }
        String repoPath = repoUri.getPath();
        return repo.lookupItem(repoPath);
    }

    private RepositoryTools() {
    }

    public static interface IFieldSetter {
        public void setValue(TransportItem var1, ILocator var2);
    }
}

