/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.impl;

import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.bytes.RandomByteProvider;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class RestrictedIdentificationProvider
implements IByteProvider {
    private static final Object NULL = new Object();
    private static final int KEY_SIZE = 16;
    private static final IByteStreamProvider RANDOM_BYTE_PROVIDER = new RandomByteProvider();
    private static final ThreadLocal<Deque<Object>> values = new ForwardedThreadLocal(){

        protected Object initialValue() {
            return new ArrayDeque();
        }
    };
    private byte[] random;

    public static void enter(Object value) {
        Deque<Object> valueHolder = values.get();
        valueHolder.push(value == null ? NULL : value);
    }

    public static Object getRestrictedIdentification() {
        Deque<Object> valueHolder = values.get();
        return valueHolder.peek();
    }

    public static void leave() {
        Deque<Object> valueHolder = values.get();
        valueHolder.pop();
    }

    public static void swap(Object value) {
        Deque<Object> valueHolder = values.get();
        valueHolder.pop();
        valueHolder.push(value == null ? NULL : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        Object ri = RestrictedIdentificationProvider.getRestrictedIdentification();
        if (ri == null || ri == NULL) {
            RestrictedIdentificationProvider restrictedIdentificationProvider = this;
            synchronized (restrictedIdentificationProvider) {
                if (this.random == null) {
                    this.random = RANDOM_BYTE_PROVIDER.getBytes(16);
                }
                return (byte[])this.random.clone();
            }
        }
        if (ri instanceof byte[]) {
            return (byte[])((byte[])ri).clone();
        }
        if (ri instanceof String) {
            return Base64.decode((String)((String)ri));
        }
        throw new IOException("restricted identification '" + ri + "' not supported");
    }
}

