/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.repository.standard;

import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.api.IRepositoryDao;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.standard.StandardRepositoryLocatorFactory;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.SchemeBasedLocatorFactory;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;

public class StandardRepository
implements IRepository {
    private IRepositoryDao repositoryDao;
    private RepositoryFolder rootFolder;

    @Override
    public void clear() throws IOException {
        this.getRepositoryDao().clear(this);
        this.rootFolder = this.getRepositoryDao().getRootFolder(this);
    }

    public void deleteDocument(RepositoryItem item) {
    }

    public void deleteFolder(RepositoryFolder folder) {
    }

    @Override
    public IRepositoryDao getRepositoryDao() {
        return this.repositoryDao;
    }

    @Override
    public RepositoryFolder getRootFolder() {
        return this.rootFolder;
    }

    @Override
    public URI getURI() {
        return URI.create("repo://main/");
    }

    @PostConstruct
    public void init() {
        if (this.getRepositoryDao() == null) {
            throw new IllegalArgumentException("dao missing");
        }
        try {
            this.clear();
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
        if (LocatorFactory.get() instanceof SchemeBasedLocatorFactory) {
            StandardRepositoryLocatorFactory repoLocatorFactory = new StandardRepositoryLocatorFactory(this);
            ((SchemeBasedLocatorFactory)LocatorFactory.get()).registerLocatorFactory("repo", (ILocatorFactory)repoLocatorFactory);
        }
    }

    @Override
    public RepositoryItem lookupItem(String repoPath) throws IOException {
        String myRepoPath = repoPath;
        if (myRepoPath.startsWith("/")) {
            myRepoPath = myRepoPath.substring(1);
        }
        RepositoryItem currentItem = this.getRootFolder();
        if (StringTools.isEmpty((String)myRepoPath)) {
            return currentItem;
        }
        String[] segments = myRepoPath.split("[/\\\\]");
        Iterator<String> itSegments = Arrays.asList(segments).iterator();
        while (itSegments.hasNext()) {
            String segment = itSegments.next();
            if (StringTools.isEmpty((String)segment)) {
                throw new IOException("invalid emtpy segment");
            }
            RepositoryItem item = currentItem.getItem(segment);
            if (item.isDocument() && itSegments.hasNext()) {
                throw new FileNotFoundException("item not found " + myRepoPath);
            }
            currentItem = item;
        }
        return currentItem;
    }

    public void setRepositoryDao(IRepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }
}

