/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.security.app;

import de.intarsys.cloudsuite.gears.security.app.ISignerSpecTransformer;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CompositeSignerSpecTransformer
implements ISignerSpecTransformer {
    @Autowired
    private Map<String, ISignerSpecTransformer> transformers = new HashMap<String, ISignerSpecTransformer>();
    private ISignerSpecTransformer defaultTransformer;

    @Override
    public <R> InstanceSpec<?> decorate(InstanceSpec<R> spec) throws ObjectCreationException {
        String id = ArgTools.getString((IArgs)spec.getArgs(), (String)"transformer", null);
        ISignerSpecTransformer transformer = null;
        transformer = StringTools.isEmpty((String)id) ? this.getDefaultTransformer() : this.transformers.get(id);
        if (transformer == null) {
            throw new IllegalArgumentException("unknown transformer '" + id + "'");
        }
        return transformer.decorate(spec);
    }

    public ISignerSpecTransformer getDefaultTransformer() {
        return this.defaultTransformer;
    }

    public Map<String, ISignerSpecTransformer> getTransformers() {
        return this.transformers;
    }

    public void registerTransformer(String id, ISignerSpecTransformer transformer) {
        this.transformers.put(id, transformer);
    }

    public void setDefaultTransformer(ISignerSpecTransformer defaultTransformer) {
        this.defaultTransformer = defaultTransformer;
    }

    public void setTransformers(Map<String, ISignerSpecTransformer> transformers) {
        this.transformers = transformers;
    }
}

