/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.service.decorate;

import de.intarsys.conversation.service.client.api.ConversationalRequest;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationalIncovationHandler
implements InvocationHandler {
    private static final Logger Log = LoggerFactory.getLogger(ConversationalIncovationHandler.class);

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        String signature = String.valueOf(obj) + "." + method.getName();
        Conversational annot = method.getAnnotation(Conversational.class);
        int index = annot.conversationArgIndex();
        String handle = null;
        if (args != null && index >= 0 && args.length > index) {
            Object arg = args[index];
            if (arg instanceof ConversationalRequest) {
                handle = ((ConversationalRequest)arg).getConversationHandle();
            } else if (arg instanceof String) {
                handle = (String)arg;
            }
        }
        Slf4jTools.addCorrelation(null, handle);
        Log.info(">> {}", (Object)signature);
        try {
            Object result = method.invoke(obj, args);
            if (handle == null && result instanceof ConversationalResponse) {
                handle = ((ConversationalResponse)result).getSnapshot().getConversationHandle();
                Slf4jTools.addCorrelation(null, (String)handle);
                Log.info("<< {} created {}", (Object)signature, (Object)handle);
            } else {
                Log.info("<< {} finished", (Object)signature);
            }
            return result;
        }
        catch (Exception e) {
            Log.info("<< {} failed", (Object)signature);
            throw e;
        }
    }
}

