/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.service.jackson;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import de.intarsys.cloudsuite.flow.json.GearsModule;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemDeserializerCallback;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemDeserializer;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonTools;
import de.intarsys.cloudsuite.gears.service.jackson.RepositoryTransportItemDeserializerCallback;
import de.intarsys.cloudsuite.gears.service.jackson.RepositoryTransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.service.jackson.WidgetExtensionModule;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import de.intarsys.widget.json.WidgetModule;

public final class JacksonMapperTools {
    public static ObjectMapper createObjectMapper(IRepository repository) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        DeserializationConfig dc = mapper.getDeserializationConfig();
        ContextAttributes attrs = ContextAttributes.getEmpty();
        attrs = JacksonTools.setRepository(attrs, repository);
        RepositoryTransportItemLocatorFactory locatorFactory = new RepositoryTransportItemLocatorFactory();
        attrs = TransportDocumentLocatorDeserializer.setLocatorFactory((ContextAttributes)attrs, (ITransportItemLocatorFactory)locatorFactory);
        dc = dc.with(attrs);
        mapper.setConfig(dc);
        mapper.registerModule((Module)new GearsModule());
        mapper.registerModule((Module)new WidgetModule());
        mapper.registerModule((Module)new WidgetExtensionModule());
        mapper.registerModule((Module)new ValidationNodeModule());
        mapper.setHandlerInstantiator(new HandlerInstantiator(){

            public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
                if (deserClass == TransportItemDeserializer.class) {
                    return new TransportItemDeserializer((ITransportItemDeserializerCallback)new RepositoryTransportItemDeserializerCallback());
                }
                return null;
            }

            public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
                return null;
            }

            public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
                return null;
            }

            public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
                return null;
            }

            public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
                return null;
            }
        });
        return mapper;
    }

    private JacksonMapperTools() {
    }
}

