/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.service.jackson;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import java.io.IOException;
import java.util.UUID;

public final class JacksonTools {
    private static final String ATTR_REPOSITORY = "repository";
    private static final String ATTR_FLOW_FOLDER = "flowFolder";
    private static final String ATTR_REPOSITORY_ITEM = "repositoryItem";

    public static RepositoryFolder getRepoFolderContext(DeserializationContext ctxt) throws IOException {
        RepositoryFolder folder = (RepositoryFolder)ctxt.getAttribute((Object)ATTR_FLOW_FOLDER);
        if (folder == null) {
            RepositoryFolder rootFolder = JacksonTools.getRepository(ctxt).getRootFolder();
            folder = rootFolder.createFolder(UUID.randomUUID().toString());
            ctxt.setAttribute((Object)ATTR_FLOW_FOLDER, (Object)folder);
        }
        return folder;
    }

    public static RepositoryFolder getRepoFolderParent(TransportItem transportItem, DeserializationContext ctxt) throws IOException {
        TransportFolder transportParent = transportItem.getParent();
        if (transportParent == null) {
            return JacksonTools.getRepoFolderContext(ctxt);
        }
        RepositoryFolder repoParent = (RepositoryFolder)JacksonTools.getRepositoryItem(transportParent);
        if (repoParent == null) {
            RepositoryFolder repoParentParent = JacksonTools.getRepoFolderParent((TransportItem)transportParent, ctxt);
            repoParent = repoParentParent.createFolder(transportParent.getName());
            JacksonTools.setRepositoryItem((TransportItem)transportParent, repoParent);
        }
        return repoParent;
    }

    public static IRepository getRepository(DeserializationContext ctxt) {
        return (IRepository)ctxt.getAttribute((Object)ATTR_REPOSITORY);
    }

    public static RepositoryItem getRepositoryItem(Object object) {
        if (object instanceof TransportItem) {
            return (RepositoryItem)((TransportItem)object).getAttribute((Object)ATTR_REPOSITORY_ITEM);
        }
        throw new IllegalArgumentException("TransportItem expected, found " + object + " instead");
    }

    public static ContextAttributes setRepository(ContextAttributes attrs, IRepository repo) {
        return attrs.withSharedAttribute((Object)ATTR_REPOSITORY, (Object)repo);
    }

    public static void setRepositoryItem(TransportItem transportItem, RepositoryItem repoItem) {
        transportItem.setAttribute((Object)ATTR_REPOSITORY_ITEM, (Object)repoItem);
    }

    private JacksonTools() {
    }
}

