/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.service.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemDeserializerCallback;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class RepositoryTransportItemDeserializerCallback
implements ITransportItemDeserializerCallback {
    public void transportDocumentCreated(TransportDocument doc, JsonParser parser, DeserializationContext ctxt) throws IOException {
    }

    public void transportDocumentDeserialized(TransportDocument doc, JsonParser parser, DeserializationContext ctxt) throws IOException {
        ILocator locator = doc.getHandle();
        if (locator != null) {
            IRepository repository = JacksonTools.getRepository(ctxt);
            RepositoryItem repoItem = repository.lookupItem(locator.getPath());
            JacksonTools.setRepositoryItem((TransportItem)doc, repoItem);
        }
    }

    public void transportFolderCreated(TransportFolder folder, JsonParser parser, DeserializationContext ctxt) throws IOException {
    }

    public void transportFolderDeserialized(TransportFolder folder, JsonParser parser, DeserializationContext ctxt) throws IOException {
        ILocator locator = folder.getHandle();
        if (locator != null) {
            IRepository repository = JacksonTools.getRepository(ctxt);
            RepositoryItem repoItem = repository.lookupItem(locator.getPath());
            JacksonTools.setRepositoryItem((TransportItem)folder, repoItem);
        }
    }
}

