/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.service.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryFolder;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryTransportItemLocatorFactory
implements ITransportItemLocatorFactory {
    private static final Logger Log = LoggerFactory.getLogger(RepositoryTransportItemLocatorFactory.class);

    public ILocator createLocator(JsonParser parser, DeserializationContext ctxt) throws IOException {
        TransportDocument doc = (TransportDocument)parser.getCurrentValue();
        RepositoryFolder parentFolder = JacksonTools.getRepoFolderParent((TransportItem)doc, ctxt);
        RepositoryDocument repoDoc = parentFolder.createDocument(doc.getName());
        if (doc.getContentType() != null) {
            repoDoc.getMetadata().setContentType(doc.getContentType());
        }
        JacksonTools.setRepositoryItem((TransportItem)doc, repoDoc);
        Log.debug("RepositoryContentLocatorFactory creating locator to {}", (Object)repoDoc.getMetadata().getName());
        return repoDoc.getLocator();
    }
}

