/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.tools.common;

import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArgumentDefinition;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import java.util.List;
import java.util.Map;

public class ArgsTransformer {
    private static final Args ARGS = Args.create();
    private Map<String, Object> definitionMap;
    private List<DtoArgumentDefinition> definitionList;
    private IArgs definitionArgs;
    private boolean expand = false;

    public ArgsTransformer(IArgs definitions, boolean expand) {
        this.definitionArgs = definitions;
        this.expand = expand;
    }

    public ArgsTransformer(List<DtoArgumentDefinition> definitions, boolean expand) {
        this.definitionList = definitions;
        this.expand = expand;
    }

    public ArgsTransformer(Map<String, Object> definitions, boolean expand) {
        this.definitionMap = definitions;
        this.expand = expand;
    }

    public IArgs apply(IArgs args) {
        Object value;
        String key;
        if (this.definitionList != null) {
            for (DtoArgumentDefinition dtoArgumentDefinition : this.definitionList) {
                key = dtoArgumentDefinition.getPath();
                value = dtoArgumentDefinition.getValue();
                ArgTools.putPathIfAbsent((IArgs)args, (String)key, () -> this.expand(LangTools.copyDeep((Object)value)));
            }
        }
        if (this.definitionMap != null) {
            for (Map.Entry entry : this.definitionMap.entrySet()) {
                key = (String)entry.getKey();
                value = entry.getValue();
                ArgTools.putPathIfAbsent((IArgs)args, (String)key, () -> this.expand(LangTools.copyDeep((Object)value)));
            }
        }
        if (this.definitionArgs != null) {
            IArgs tmpArgs = this.definitionArgs.copy();
            ArgTools.applyDeep((IArgs)tmpArgs, binding -> this.expand(binding.getValue()));
            ArgTools.putAllIfAbsentDeep((IArgs)args, (IArgs)tmpArgs);
        }
        return args;
    }

    protected Object expand(Object value) {
        Object newValue = value;
        if (this.isExpand()) {
            newValue = LangTools.applyDeep((Object)newValue, binding -> {
                Object member = binding.getValue();
                try {
                    member = StringEvaluatorTools.evaluate((IStringEvaluator)TemplateEvaluator.get((Mode)Mode.UNTRUSTED), (Object)member, (IArgs)ARGS);
                    return LangTools.copyDeep((Object)member);
                }
                catch (Exception ex) {
                    return member;
                }
            });
        }
        return (newValue = ArgTools.toArgsValue((Object)newValue)) == null ? ArgTools.UNDEFINED : newValue;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setDefinitions(IArgs definitions) {
        this.definitionArgs = definitions;
    }

    public void setDefinitions(Map<String, Object> definitions) {
        this.definitionMap = definitions;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }
}

