/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.tools.spring;

import de.intarsys.cloudsuite.gears.core.service.common.impl.SettingsGroup;
import de.intarsys.cloudsuite.tools.common.Settings;
import de.intarsys.cloudsuite.tools.common.SettingsMeta;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;

public class MapToSettingsConverter
implements Converter<Map<String, Object>, Settings> {
    public Settings convert(Map<String, Object> value) {
        Settings result = new Settings();
        result.setMeta((IArgs)Args.create());
        result.setValues((IArgs)Args.create());
        Set<Map.Entry<String, Object>> entrySet = value.entrySet();
        for (Map.Entry<String, Object> definition : entrySet) {
            this.convert(result, definition);
        }
        if (result.getMeta().size() == 0) {
            result.setMeta(null);
        }
        if (result.getValues().size() == 0) {
            result.setValues(null);
        }
        return result;
    }

    protected void convert(Settings result, Map.Entry<String, Object> definition) {
        String key = definition.getKey();
        Object value = definition.getValue();
        if (value instanceof SettingsGroup) {
            SettingsGroup sg = (SettingsGroup)value;
            if (!sg.isEditable()) {
                ArgTools.putPath((IArgs)result.getMeta(), (String)(key + "._meta.editable"), (Object)false);
            }
            ArgTools.putPath((IArgs)result.getValues(), (String)key, (Object)sg.getValues());
        } else if (value instanceof SettingsMeta) {
            SettingsMeta sm = (SettingsMeta)value;
            if (key.endsWith("_meta")) {
                ArgTools.putPath((IArgs)result.getMeta(), (String)key, (Object)value);
            } else {
                ArgTools.putPath((IArgs)result.getMeta(), (String)(key + "._meta"), (Object)sm);
            }
        } else if (key.contains("_meta.")) {
            ArgTools.putPath((IArgs)result.getMeta(), (String)key, (Object)value);
        } else {
            ArgTools.putPath((IArgs)result.getValues(), (String)key, (Object)value);
        }
    }
}

