/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.PACKAGE;
import de.intarsys.tools.activity.RequestConfirmation;
import de.intarsys.tools.activity.Requester;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.File;

public class RequestFile
extends Requester<String, IActivity<?>> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String initialPath;
    private String[] fileTypeExtensions;
    private String[] fileTypeNames;
    private String initialFilename;
    private boolean checkOverwrite;
    private String filename;
    private boolean queryDirectory;
    private boolean queryLoad = true;
    private int defaultExtensionIndex;

    protected static RequestFile createBasic(IActivity parent, IMessage title, String path) {
        RequestFile result = new RequestFile(parent);
        result.setTitle(title);
        result.setInitialPath(path);
        return result;
    }

    protected static RequestFile createBasicFile(IActivity parent, IMessage title, String path, String[] extensions, String[] names) {
        RequestFile result = RequestFile.createBasic(parent, title, path);
        result.setFileTypeExtensions(extensions);
        result.setFileTypeNames(names);
        return result;
    }

    public static RequestFile createDirectory(IActivity parent, IMessage title, IMessage message, String path) {
        RequestFile result = RequestFile.createBasic(parent, title, path);
        result.setMessage(message);
        result.setQueryDirectory(true);
        return result;
    }

    public static RequestFile createFileLoad(IActivity parent, IMessage title, String[] extensions, String[] names, String path) {
        RequestFile result = RequestFile.createBasicFile(parent, title, path, extensions, names);
        result.setQueryDirectory(false);
        result.setQueryLoad(true);
        return result;
    }

    public static RequestFile createFileOrDirectory(IActivity parent, IMessage title, String[] extensions, String[] names, String path) {
        RequestFile result = RequestFile.createBasicFile(parent, title, path, extensions, names);
        result.setQueryDirectory(true);
        result.setQueryLoad(true);
        return result;
    }

    public static RequestFile createFileSave(IActivity parent, IMessage title, String[] extensions, String[] names, String path, String filename, boolean checkOverwrite) {
        RequestFile result = RequestFile.createBasicFile(parent, title, path, extensions, names);
        result.setInitialFilename(filename);
        result.setCheckOverwrite(checkOverwrite);
        result.setQueryDirectory(false);
        result.setQueryLoad(false);
        return result;
    }

    public static String requestDirectory(IMessage title, IMessage message, String path) {
        RequestFile dialog = RequestFile.createDirectory(null, title, message, path);
        dialog.enter();
        return (String)dialog.getAnyway();
    }

    public static String requestFileLoad(IMessage title, String[] extensions, String[] names, String path) {
        return RequestFile.requestFileLoad(title, extensions, names, path, 0);
    }

    public static String requestFileLoad(IMessage title, String[] extensions, String[] names, String path, int defaultExtensionIndex) {
        RequestFile dialog = RequestFile.createFileLoad(null, title, extensions, names, path);
        dialog.setDefaultExtensionIndex(defaultExtensionIndex);
        dialog.enter();
        return (String)dialog.getAnyway();
    }

    public static String requestFileOrDirectory(IMessage title, String[] extensions, String[] names, String path, int defaultExtensionIndex) {
        RequestFile dialog = RequestFile.createFileOrDirectory(null, title, extensions, names, path);
        dialog.setDefaultExtensionIndex(defaultExtensionIndex);
        dialog.enter();
        return (String)dialog.getAnyway();
    }

    public static String requestFileSave(IMessage title, String[] extensions, String[] names, String path, String filename, boolean checkOverwrite) {
        RequestFile dialog = RequestFile.createFileSave(null, title, extensions, names, path, filename, checkOverwrite);
        dialog.enter();
        return (String)dialog.getAnyway();
    }

    public RequestFile(IActivity<?> parent) {
        super(parent);
    }

    @Override
    protected void basicEnterBefore() throws Exception {
        super.basicEnterBefore();
        if (this.fileTypeExtensions != null && this.fileTypeNames != null) {
            String extension = "*." + PathTools.getExtension(this.initialFilename);
            for (int i = 0; i < this.fileTypeExtensions.length; ++i) {
                if (!this.fileTypeExtensions[i].equals(extension)) continue;
                String tempExtension = this.fileTypeExtensions[i];
                System.arraycopy(this.fileTypeExtensions, 0, this.fileTypeExtensions, 1, i);
                this.fileTypeExtensions[0] = tempExtension;
                String tempName = this.fileTypeNames[i];
                System.arraycopy(this.fileTypeNames, 0, this.fileTypeNames, 1, i);
                this.fileTypeNames[0] = tempName;
                break;
            }
        }
    }

    public int getDefaultExtensionIndex() {
        return this.defaultExtensionIndex;
    }

    @Override
    protected String getDefaultResult() {
        return this.getFilename();
    }

    public String getFilename() {
        return this.filename;
    }

    public String[] getFileTypeExtensions() {
        return this.fileTypeExtensions;
    }

    public String[] getFileTypeNames() {
        return this.fileTypeNames;
    }

    public String getInitialFilename() {
        return this.initialFilename;
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public boolean isCheckOverwrite() {
        return this.checkOverwrite;
    }

    public boolean isQueryDirectory() {
        return this.queryDirectory;
    }

    public boolean isQueryLoad() {
        return this.queryLoad;
    }

    public void setCheckOverwrite(boolean checkOverwrite) {
        this.checkOverwrite = checkOverwrite;
    }

    public void setDefaultExtensionIndex(int defaultExtensionIndex) {
        this.defaultExtensionIndex = defaultExtensionIndex;
    }

    public void setFilename(String resultName) {
        this.filename = resultName;
    }

    public void setFileTypeExtensions(String[] extensions) {
        this.fileTypeExtensions = extensions;
    }

    public void setFileTypeNames(String[] names) {
        this.fileTypeNames = names;
    }

    public void setInitialFilename(String filename) {
        this.initialFilename = filename;
    }

    public void setInitialPath(String path) {
        this.initialPath = path;
    }

    public void setQueryDirectory(boolean directoryDialog) {
        this.queryDirectory = directoryDialog;
    }

    public void setQueryLoad(boolean load) {
        this.queryLoad = load;
    }

    @Override
    protected boolean validate(String value) {
        IMessage msgMessage;
        IMessage msgTitle;
        IMessage response;
        String resultName = this.getFilename();
        if (StringTools.isEmpty(resultName)) {
            return true;
        }
        if (resultName.indexOf(46) == resultName.length() - 1) {
            resultName = resultName.substring(0, resultName.length() - 1);
        }
        File file = new File(resultName);
        if (this.checkOverwrite && file.exists() && (response = RequestConfirmation.requestYesNo(null, msgTitle = Msg.getMessage("RequestFile.TitleSaveAs", new Object[0]), msgMessage = Msg.getMessage("RequestFile.QuerySaveAsAlreadyExists", file.getName()), RequestConfirmation.OPTION_YES)) != RequestConfirmation.OPTION_YES) {
            String newParent = file.getParent();
            if (newParent != null) {
                this.setInitialPath(newParent);
            }
            return false;
        }
        return true;
    }
}

