/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.AbstractFuture;

public abstract class AbstractFutureTask<R>
extends AbstractFuture<R>
implements Runnable {
    private boolean asynch;
    protected Thread runner;

    protected AbstractFutureTask() {
    }

    @Override
    protected void checkInterrupt() {
        if (this.runner != null) {
            this.runner.interrupt();
        }
    }

    protected abstract R compute() throws Exception;

    public boolean isAsynch() {
        return this.asynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object tempResult;
        Object object = this.lockTask;
        synchronized (object) {
            if (this.active || this.cancelled || this.computed) {
                Log.trace("{} will not run, already {}", (Object)this.getLabel(), (Object)this.getStateString());
                return;
            }
            this.active = true;
            this.runner = Thread.currentThread();
        }
        try {
            this.taskStarted();
            Log.trace("{} started", (Object)this.getLabel());
            tempResult = this.compute();
            if (!this.isAsynch() && !this.isCancelled()) {
                this.setResult(tempResult);
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
        finally {
            tempResult = this.lockTask;
            synchronized (tempResult) {
                this.runner = null;
            }
        }
    }

    public final void runAsync() {
        this.setAsynch(true);
        this.run();
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }
}

