/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.dom.AttributeAttributeAdapter;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.infoset.AbstractElement;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.xml.TransformerTools;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementElementAdapter
extends AbstractElement
implements IStringEvaluatorAccess {
    private final Element element;
    private IStringEvaluator stringEvaluator;
    private IStringEvaluator templateEvaluator;

    public ElementElementAdapter(Element element, boolean indexed) {
        super(indexed);
        this.element = element;
    }

    public ElementElementAdapter(Element element, boolean indexed, IStringEvaluator evaluator) {
        super(indexed);
        this.element = element;
        this.setStringEvaluator(evaluator);
    }

    @Override
    public String asXML() {
        String string;
        StringWriter output = new StringWriter();
        try {
            TransformerTools.createSecureTransformerFactory().newTransformer().transform(new DOMSource(this.element), new StreamResult(output));
            string = output.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                return "<error>";
            }
        }
        output.close();
        return string;
    }

    @Override
    public IAttribute attribute(String name) {
        Attr attr = this.element.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return new AttributeAttributeAdapter(this, attr);
    }

    @Override
    public Iterator<IAttribute> attributeIterator() {
        return new Iterator<IAttribute>(){
            NamedNodeMap map;
            int index;
            {
                this.map = ElementElementAdapter.this.element.getAttributes();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.map.getLength();
            }

            @Override
            public IAttribute next() {
                if (this.hasNext()) {
                    return new AttributeAttributeAdapter(ElementElementAdapter.this, (Attr)this.map.item(this.index++));
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Iterator<String> attributeNames() {
        return new Iterator<String>(){
            NamedNodeMap map;
            int index;
            {
                this.map = ElementElementAdapter.this.element.getAttributes();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.map.getLength();
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return ((Attr)this.map.item(this.index++)).getName();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    protected Object basicGetAttributeData(IAttribute attribute, String name) {
        Attr impl = ((AttributeAttributeAdapter)attribute).getAttr();
        return this.convertRawToData(impl.getValue());
    }

    @Override
    protected Object basicGetAttributeRaw(IAttribute attribute, String name) {
        Attr impl = ((AttributeAttributeAdapter)attribute).getAttr();
        return impl.getValue();
    }

    @Override
    protected String basicGetAttributeValue(IAttribute attribute, String name) {
        Attr impl = ((AttributeAttributeAdapter)attribute).getAttr();
        return this.toString(this.convertRawToData(impl.getValue()));
    }

    @Override
    protected void basicSetAttributeData(IAttribute attribute, String name, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void basicSetAttributeRaw(IAttribute abstractAttribute, String name, Object raw) {
        if (raw == null) {
            this.element.removeAttribute(name);
        } else {
            this.element.setAttribute(name, String.valueOf(raw));
        }
    }

    @Override
    protected void basicSetAttributeValue(IAttribute attribute, String name, String value) {
        if (value == null) {
            this.element.removeAttribute(name);
        } else {
            this.element.setAttribute(name, (String)this.convertDataToRaw(value));
        }
    }

    @Override
    protected Object convertDataToRaw(Object data) {
        if (data == null) {
            return null;
        }
        return DirectTagReader.escape(String.valueOf(data));
    }

    @Override
    protected Object convertRawToData(Object raw) {
        if (raw == null) {
            return raw;
        }
        return StringEvaluatorTools.evaluate(this.templateEvaluator, raw);
    }

    @Override
    public IElement element(String name) {
        Element child = DOMTools.getElementFirst(this.element, name);
        return child == null ? null : new ElementElementAdapter(child, false, this.stringEvaluator);
    }

    @Override
    public Iterator<IElement> elementIterator() {
        return new ConversionIterator<Element, IElement>(DOMTools.getElements(this.element).iterator()){

            @Override
            protected IElement createTargetObject(Element element) {
                return new ElementElementAdapter(element, false, ElementElementAdapter.this.stringEvaluator);
            }
        };
    }

    @Override
    public Iterator<IElement> elementIterator(String name) {
        return new ConversionIterator<Element, IElement>(DOMTools.getElements(this.element, name).iterator()){

            @Override
            protected IElement createTargetObject(Element element) {
                return new ElementElementAdapter(element, false, ElementElementAdapter.this.stringEvaluator);
            }
        };
    }

    @Override
    public void elementRemove(IElement pElement) {
        this.element.removeChild(((ElementElementAdapter)pElement).getElement());
    }

    @Override
    public void elementsClear() {
        NodeList list = this.element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            this.element.removeChild(node);
        }
    }

    @Override
    public String elementText(String name) {
        IElement child = this.element(name);
        if (child == null) {
            return null;
        }
        return child == null ? null : child.getText();
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public String getText() {
        Object value = this.convertRawToData(this.element.getTextContent());
        return this.toString(value);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    @Override
    public boolean hasAttributes() {
        return this.element.hasAttributes();
    }

    @Override
    public boolean hasElements() {
        return DOMTools.hasElements(this.element);
    }

    @Override
    public boolean hasElements(String name) {
        return DOMTools.hasElements(this.element, name);
    }

    protected Element myElement() {
        return this.element;
    }

    @Override
    public IAttribute newAttribute(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        this.element.setAttribute(name, "");
        return this.attribute(name);
    }

    @Override
    public IElement newElementIndexed(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        Element tempElement = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(tempElement);
        return new ElementElementAdapter(tempElement, true, this.stringEvaluator);
    }

    @Override
    public IElement newElementMapped(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        Element tempElement = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(tempElement);
        return new ElementElementAdapter(tempElement, false, this.stringEvaluator);
    }

    @Override
    public Iterator<INode> nodeIterator() {
        return new Iterator<INode>(){
            NodeList nodes;
            int index;
            Node childNode;
            {
                this.nodes = ElementElementAdapter.this.element.getChildNodes();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                while (this.childNode == null && this.index < this.nodes.getLength()) {
                    Node tmpNode;
                    if ((tmpNode = this.nodes.item(this.index++)).getNodeType() != 1 && tmpNode.getNodeType() != 2) continue;
                    this.childNode = tmpNode;
                }
                return this.childNode != null;
            }

            @Override
            public INode next() {
                try {
                    if (this.hasNext()) {
                        if (this.childNode.getNodeType() == 1) {
                            ElementElementAdapter elementElementAdapter = new ElementElementAdapter((Element)this.childNode, false, ElementElementAdapter.this.stringEvaluator);
                            return elementElementAdapter;
                        }
                        AttributeAttributeAdapter attributeAttributeAdapter = new AttributeAttributeAdapter(ElementElementAdapter.this, (Attr)this.childNode);
                        return attributeAttributeAdapter;
                    }
                }
                finally {
                    this.childNode = null;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void nodeRemove(String name) {
        Element child = DOMTools.getElementFirst(this.element, name);
        if (child != null) {
            this.element.removeChild(child);
            return;
        }
        this.element.removeAttribute(name);
    }

    @Override
    public void setName(String name) {
        this.element.getOwnerDocument().renameNode(this.element, null, name);
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
        this.templateEvaluator = this.stringEvaluator == null ? null : TaggedStringEvaluator.decorate(evaluator);
    }

    @Override
    public void setText(String value) {
        this.element.setTextContent(value);
    }

    @Override
    protected String toString(Object value) {
        return ElementTools.toString(value);
    }
}

