/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.Domain;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.presentation.IPresentationSupport;

public class DomainItem<T>
extends EnumItem {
    public static final Object MATCH_ANY = new Object();
    private T object;

    protected DomainItem(Domain<T> domain, String id, T object) {
        super(domain, id, null, domain.size());
        this.object = object;
        if (object instanceof IPresentationSupport) {
            this.setLabel(((IPresentationSupport)object).getLabel());
        } else if (object instanceof IMessage) {
            this.setLabel(object);
        } else {
            this.setLabel(id);
        }
    }

    protected boolean accept(T pObject) {
        if (pObject == null) {
            return this.getObject() == null;
        }
        if (this.getObject() instanceof IArgs && pObject instanceof IArgs) {
            for (IArgs.IBinding binding : (IArgs)this.getObject()) {
                Object a = binding.getValue();
                Object b = ((IArgs)pObject).get(binding.getName());
                if (a == MATCH_ANY || b == MATCH_ANY || LangTools.equals(a, b)) continue;
                return false;
            }
            return true;
        }
        return pObject.equals(this.getObject());
    }

    public T getObject() {
        return this.object;
    }

    @Override
    public void setDefault() {
        super.setDefault();
    }

    @Override
    public void setIconName(String iconName) {
        super.setIconName(iconName);
    }

    @Override
    public void setLabel(Object label) {
        super.setLabel(label);
    }
}

