/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.string.StringTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnumMeta<T extends EnumItem> {
    private final Class enumClazz;
    private final List<T> items = new ArrayList<T>();
    private T enumDefault;

    public EnumMeta(Class enumClazz) {
        this.enumClazz = enumClazz;
    }

    protected void addItem(T item) {
        this.items.add(item);
        if (this.items.size() == 1) {
            ((EnumItem)item).setDefault();
        }
    }

    public T getDefault() {
        return this.enumDefault;
    }

    public Class getEnumClazz() {
        return this.enumClazz;
    }

    public T getItem(String id) {
        if (StringTools.isEmpty(id)) {
            return null;
        }
        for (EnumItem element : this.items) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        return null;
    }

    public T getItem(String id, String defaultValue) {
        T item = this.getItem(id);
        return item == null ? this.getItem(defaultValue) : item;
    }

    public T getItem(String id, T defaultValue) {
        T item = this.getItem(id);
        return item == null ? defaultValue : item;
    }

    public T getItemOrDefault(String id) {
        T item = this.getItem(id);
        return item == null ? this.getDefault() : item;
    }

    public T[] getItems() {
        return this.items.toArray((EnumItem[])Array.newInstance(this.enumClazz, this.items.size()));
    }

    public T getItemStrict(String id) {
        if (StringTools.isEmpty(id)) {
            return null;
        }
        for (EnumItem element : this.items) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        throw new IllegalArgumentException("enum " + this.getEnumClazz() + " does not support item " + id);
    }

    public T getItemStrict(String id, T defaultValue) {
        if (StringTools.isEmpty(id)) {
            return defaultValue;
        }
        for (EnumItem element : this.items) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        throw new IllegalArgumentException("enum " + this.getEnumClazz() + " does not support item " + id);
    }

    public T getItemStrictOrDefault(String id) {
        T item = this.getItemStrict(id);
        return item == null ? this.getDefault() : item;
    }

    public T getMax() {
        EnumItem max = null;
        for (EnumItem element : this.items) {
            if (max != null && element.getWeight() <= max.getWeight()) continue;
            max = element;
        }
        return (T)max;
    }

    public T getMin() {
        EnumItem min = null;
        for (EnumItem element : this.items) {
            if (min != null && element.getWeight() >= min.getWeight()) continue;
            min = element;
        }
        return (T)min;
    }

    protected void setDefault(T item) {
        this.enumDefault = item;
    }

    public int size() {
        return this.items.size();
    }

    public void sort() {
        this.sort(new Comparator<EnumItem>(){

            @Override
            public int compare(EnumItem o1, EnumItem o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
    }

    public void sort(Comparator<EnumItem> c) {
        Collections.sort(this.items, c);
    }
}

