/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.exception.ICancellationException;
import de.intarsys.tools.exception.ICodeException;
import de.intarsys.tools.exception.IWrappingException;
import de.intarsys.tools.exception.KnownReason;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ExceptionTools {
    private static final String SUFFIX_EXCEPTION = "Exception";
    private static final Set<Class<?>> WrappingExceptions = new HashSet();

    public static IllegalArgumentException argumentInvalid(String argument, String message, Throwable t) {
        if (StringTools.isEmpty(message)) {
            return new IllegalArgumentException(String.format("Argument %s invalid", argument), t);
        }
        return new IllegalArgumentException(String.format("Argument %s invalid, %s", argument, message), t);
    }

    public static IllegalArgumentException argumentRequired(String argument) {
        return new IllegalArgumentException(String.format("Argument %s required", argument));
    }

    @Deprecated
    public static RuntimeException asRuntime(String msg, Throwable t) {
        return ExceptionTools.wrap(t);
    }

    @Deprecated
    public static RuntimeException asRuntime(Throwable t) {
        return ExceptionTools.wrap(t);
    }

    public static CancellationException cancellation() {
        return new CancellationException();
    }

    public static CompletionException completionException(Throwable t) {
        return new CompletionException(t);
    }

    public static <T extends Throwable> T createTyped(Throwable t, Class<T> clazz) {
        return ExceptionTools.createTyped(t, clazz, ExceptionTools.getMessageShort(t));
    }

    public static <T extends Throwable> T createTyped(Throwable t, Class<T> clazz, String message) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        try {
            Method method = clazz.getDeclaredMethod("create", String.class, Throwable.class);
            return (T)((Throwable)method.invoke(null, message, t));
        }
        catch (Exception method) {
            try {
                Method method2 = clazz.getDeclaredMethod("create", Throwable.class);
                return (T)((Throwable)method2.invoke(null, t));
            }
            catch (Exception method2) {
                try {
                    Constructor<T> c = clazz.getConstructor(String.class, Throwable.class);
                    return (T)((Throwable)c.newInstance(message, t));
                }
                catch (Exception c) {
                    try {
                        Constructor<T> c2 = clazz.getConstructor(Throwable.class);
                        return (T)((Throwable)c2.newInstance(t));
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("failed creating exception type " + clazz.getName(), t);
                    }
                }
            }
        }
    }

    public static <T extends Throwable> T createTypedFromChain(Throwable t, Class<T> clazz) {
        T inChain = ExceptionTools.getFromChain(t, clazz);
        if (inChain != null) {
            return inChain;
        }
        return ExceptionTools.createTyped(t, clazz);
    }

    public static void fail() {
        throw new RuntimeException("failed");
    }

    public static <T> T futureSimpleGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionTools.wrap(e);
        }
        catch (ExecutionException ex) {
            throw ExceptionTools.wrap(ExceptionTools.unwrap(ex));
        }
    }

    public static <T extends Number> T futureSimpleGetNumber(Future<T> future) {
        Number result = (Number)ExceptionTools.futureSimpleGet(future);
        if (result == null) {
            result = -1;
        }
        return (T)result;
    }

    public static <T> T futureSimpleGetOrDefault(Future<T> future, Supplier<T> defaultSupplier) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultSupplier.get();
    }

    public static <T extends Throwable> T getCause(Throwable e, Class<T> exceptionType) {
        return (T)ExceptionTools.getCause(e, exceptionType, c -> ExceptionTools.createTyped(c, exceptionType));
    }

    public static <T extends Throwable> T getCause(Throwable e, Class<T> exceptionType, Function<Throwable, T> wrap) {
        if (exceptionType.isInstance(e)) {
            return (T)e;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return (T)((Throwable)wrap.apply(e));
        }
        if (exceptionType.isInstance(cause)) {
            return (T)cause;
        }
        return (T)((Throwable)wrap.apply(cause));
    }

    public static String getCode(Throwable t) {
        if (t instanceof ICodeException) {
            return ((ICodeException)((Object)t)).getCode();
        }
        String tmpCode = ClassTools.getUnqualifiedName(t.getClass());
        if (tmpCode.endsWith(SUFFIX_EXCEPTION)) {
            tmpCode = tmpCode.substring(0, tmpCode.length() - SUFFIX_EXCEPTION.length());
        }
        return tmpCode;
    }

    public static <T extends Throwable> T getFromChain(Throwable t, Class<T> clazz) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        if (t.getCause() != null) {
            return ExceptionTools.getFromChain(t.getCause(), clazz);
        }
        return null;
    }

    public static String getMessage(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(ExceptionTools.getCode(t));
        String tempMsg = t.getLocalizedMessage();
        if (tempMsg != null) {
            sb.append(" - ");
            sb.append(tempMsg);
        }
        return sb.toString();
    }

    public static String getMessageShort(Throwable t) {
        String tempMsg = t.getLocalizedMessage();
        if (!StringTools.isEmpty(tempMsg)) {
            return tempMsg;
        }
        return ExceptionTools.getMessage(t);
    }

    public static Throwable getRoot(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isCancellation(Throwable t) {
        if (t == null) {
            return false;
        }
        if (ExceptionTools.isInChain(t, CancellationException.class)) {
            return true;
        }
        if (ExceptionTools.isInChain(t, ICancellationException.class)) {
            return true;
        }
        return ExceptionTools.isInChain(t, InterruptedException.class);
    }

    public static boolean isInChain(Throwable t, Class<?> clazz) {
        if (t == null) {
            return false;
        }
        if (clazz.isInstance(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return ExceptionTools.isInChain(t.getCause(), clazz);
        }
        return false;
    }

    public static boolean isInChain(Throwable t, String classname) {
        if (t == null) {
            return false;
        }
        if (t.getClass().getName().equals(classname)) {
            return true;
        }
        if (t.getCause() != null) {
            return ExceptionTools.isInChain(t.getCause(), classname);
        }
        return false;
    }

    public static boolean isKnownReason(Throwable t) {
        return ExceptionTools.isInChain(t, KnownReason.class);
    }

    public static boolean isTimeout(Throwable t) {
        return ExceptionTools.isInChain(t, TimeoutException.class);
    }

    public static IArgs toArgs(Throwable t, boolean recursive, boolean includeStacktrace) {
        Args args = Args.create();
        args.put("_class", (Object)t.getClass().getName());
        args.put("message", (Object)t.getMessage());
        if (includeStacktrace) {
            args.put("stacktrace", (Object)ExceptionTools.getStackTraceString(t));
        }
        if (recursive && t.getCause() != null) {
            args.put("cause", (Object)ExceptionTools.toArgs(t.getCause(), recursive, includeStacktrace));
        }
        return args;
    }

    public static Throwable unwrap(Throwable t) {
        if (t == null) {
            return null;
        }
        if (WrappingExceptions.contains(t.getClass()) || t instanceof IWrappingException) {
            Throwable cause = t.getCause();
            return cause == null ? t : ExceptionTools.unwrap(cause);
        }
        return t;
    }

    @Deprecated
    public static <T extends Throwable> T unwrap(Throwable t, Class<T> clazz) {
        return ExceptionTools.unwrapTyped(t, clazz);
    }

    public static <T extends Throwable> T unwrapTyped(Throwable t, Class<T> clazz) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        return ExceptionTools.createTyped(ExceptionTools.unwrap(t), clazz);
    }

    public static <T extends Throwable> T unwrapTyped(Throwable t, Class<T> clazz, String message) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        return ExceptionTools.createTyped(ExceptionTools.unwrap(t), clazz, message);
    }

    public static <T extends Throwable> T unwrapTypedFromChain(Throwable t, Class<T> clazz) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        return ExceptionTools.createTypedFromChain(ExceptionTools.unwrap(t), clazz);
    }

    public static Throwable withMessage(Throwable t, String message) {
        try {
            Class<?> clazz = t.getClass();
            Constructor<?> c = clazz.getConstructor(String.class, Throwable.class);
            return (Throwable)c.newInstance(message, t);
        }
        catch (Exception e) {
            return t;
        }
    }

    public static Throwable withMessagePrefix(Throwable t, String prefix) {
        String message = prefix + ExceptionTools.getMessageShort(t);
        return ExceptionTools.withMessage(t, message);
    }

    public static RuntimeException wrap(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof IOException) {
            return new UncheckedIOException((IOException)t);
        }
        return new TunnelingException(t);
    }

    @Deprecated
    public static RuntimeException wrap(Throwable t, Class clazz) {
        return ExceptionTools.wrapTyped(t, clazz);
    }

    public static Exception wrapAsException(Throwable t) {
        if (t == null) {
            return null;
        }
        return t instanceof Exception ? (Exception)t : ExceptionTools.wrap(t);
    }

    @Deprecated
    public static RuntimeException wrapFromChain(Throwable t, Class clazz) {
        return ExceptionTools.wrapTypedFromChain(t, clazz);
    }

    public static RuntimeException wrapTyped(Throwable t, Class clazz) {
        return ExceptionTools.wrap(ExceptionTools.createTyped(t, clazz));
    }

    public static RuntimeException wrapTypedFromChain(Throwable t, Class clazz) {
        return ExceptionTools.wrap(ExceptionTools.createTypedFromChain(t, clazz));
    }

    public static RuntimeException wrapWithMessage(Throwable t, String message) {
        return ExceptionTools.wrap(ExceptionTools.withMessage(t, message));
    }

    public static RuntimeException wrapWithMessagePrefix(Throwable t, String prefix) {
        return ExceptionTools.wrap(ExceptionTools.withMessagePrefix(t, prefix));
    }

    private ExceptionTools() {
    }

    static {
        WrappingExceptions.add(CompletionException.class);
        WrappingExceptions.add(ExecutionException.class);
        WrappingExceptions.add(ObjectCreationException.class);
        WrappingExceptions.add(InvocationTargetException.class);
        WrappingExceptions.add(UncheckedIOException.class);
    }
}

