/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

public class MapResolver
extends ContainerResolver {
    private final Map<String, Object> variables;

    public static MapResolver create() {
        return new MapResolver();
    }

    public static MapResolver create(String key, IStringEvaluator resolver) {
        return new MapResolver().put(key, resolver);
    }

    public static MapResolver createStrict() {
        return new MapResolver(true);
    }

    public static MapResolver createStrict(Map<String, Object> variables) {
        return new MapResolver(variables, true);
    }

    public static MapResolver createStrict(String key, IStringEvaluator resolver) {
        return MapResolver.createStrict().put(key, resolver);
    }

    public MapResolver() {
        this(new HashMap<String, Object>(), false);
    }

    @Deprecated(since="4.24")
    public MapResolver(boolean strict) {
        this(new HashMap<String, Object>(), strict);
    }

    public MapResolver(Map<String, Object> variables) {
        this(variables, false);
    }

    @Deprecated(since="4.24")
    public MapResolver(Map<String, Object> variables, boolean strict) {
        super('.', strict, null);
        this.variables = new HashMap<String, Object>(variables);
    }

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        if (this.variables.containsKey(expression)) {
            return this.variables.get(expression);
        }
        return this.notFound(expression);
    }

    public Object get(String key) {
        return this.variables.get(key);
    }

    public MapResolver put(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public static class Install {
        private MapResolver target;
        private IStringEvaluator evaluator;
        private String name;

        public IStringEvaluator getEvaluator() {
            return this.evaluator;
        }

        public String getName() {
            return this.name;
        }

        public MapResolver getTarget() {
            return this.target;
        }

        @PostConstruct
        public void install() {
            this.getTarget().put(this.getName(), this.getEvaluator());
        }

        public void setEvaluator(IStringEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTarget(MapResolver target) {
            this.target = target;
        }
    }
}

