/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;

public class GenericFactory<T>
extends CommonInstantiatingFactory<T> {
    public static final String EN_TEMPLATE = "template";
    private String configNameResultClass = "resultClass";
    private IElement template;
    private Class resultClass = Object.class;

    @Override
    protected T basicCreateInstance(IArgs args) throws ObjectCreationException {
        IElement config;
        IElement myTemplate = this.getTemplate();
        if (myTemplate == null && (config = (IElement)args.get("configuration")) != null) {
            myTemplate = config.element(EN_TEMPLATE);
        }
        if (myTemplate == null) {
            throw new ObjectCreationException("template missing");
        }
        IArgs initArgs = ArgTools.getArgs(args, "properties", Args.create());
        return ElementTools.createObject(myTemplate, this.resultClass, this.getContext(args), initArgs);
    }

    @Override
    protected void basicCreateInstanceConfig(T object, IArgs args) throws ObjectCreationException {
    }

    @Override
    public void basicCreateInstanceInit(T object, IArgs args) {
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        super.configure(pElement);
        this.setTemplate(pElement.element(EN_TEMPLATE));
        try {
            this.setResultClass(ElementTools.createClass(pElement, this.getConfigNameResultClass(), Object.class, this));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    public String getConfigNameResultClass() {
        return this.configNameResultClass;
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected String getDefaultId() {
        if (this.getTemplate() != null) {
            return ElementTools.getString(this.getTemplate(), "class", null);
        }
        return super.getDefaultId();
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    @Override
    public Class<T> getResultType() {
        return this.resultClass;
    }

    public IElement getTemplate() {
        return this.template;
    }

    public void setConfigNameResultClass(String configNameResultClass) {
        this.configNameResultClass = configNameResultClass;
    }

    public void setResultClass(Class resultClass) {
        if (resultClass == null) {
            resultClass = Object.class;
        }
        this.resultClass = resultClass;
    }

    public void setTemplate(IElement template) {
        this.template = template;
    }

    public void validate() throws ObjectCreationException {
        ElementTools.createClass(this.getTemplate(), "class", Object.class, this);
    }
}

