/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public class DeclarationFunctor<T>
implements IFunctor<T>,
IElementConfigurable,
IElementSerializable,
IDeclarationSupport,
IContextSupport,
IPresentationSupport {
    private final IDeclarationBlock declarationBlock = new DeclarationBlock(this);
    private IFunctor functor;
    private Object context;

    public DeclarationFunctor() {
    }

    public DeclarationFunctor(IFunctor functor) {
        this.functor = functor;
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.setFunctor(this.createImplementor(pElement));
        try {
            this.declarationBlock.clear();
            new DeclarationIO().deserializeDeclarationBlock(this.declarationBlock, pElement);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    protected IFunctorCall createCall(IFunctorCall call) throws FunctorException {
        try {
            new ArgumentDeclarator().apply(this.getDeclarationBlock(), call.getArgs());
            return call;
        }
        catch (DeclarationException e) {
            throw new FunctorExecutionException(e);
        }
    }

    protected IFunctor createImplementor(IElement element) throws ConfigurationException {
        IElement implementorElement = element.element("implementor");
        if (implementorElement != null) {
            try {
                return ElementTools.createObject(implementorElement, IFunctor.class, this.getContext(), Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException(e);
            }
        }
        return null;
    }

    public Object getContext() {
        return this.context;
    }

    @Override
    public IDeclarationBlock getDeclarationBlock() {
        return this.declarationBlock;
    }

    @Override
    public String getDescription() {
        if (this.functor instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.functor)).getDescription();
        }
        return this.getTip();
    }

    public IFunctor getFunctor() {
        return this.functor;
    }

    @Override
    public String getIconName() {
        if (this.functor instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.functor)).getIconName();
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.functor instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.functor)).getLabel();
        }
        return StringTools.safeString(this.functor);
    }

    @Override
    public String getTip() {
        if (this.functor instanceof IPresentationSupport) {
            return ((IPresentationSupport)((Object)this.functor)).getTip();
        }
        return this.getLabel();
    }

    @Override
    public T perform(IFunctorCall call) throws FunctorException {
        try {
            if (this.getFunctor() != null) {
                IFunctorCall forwardCall = this.createCall(call);
                return this.getFunctor().perform(forwardCall);
            }
            return null;
        }
        catch (FunctorException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new FunctorExecutionException(t);
        }
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        IElement implementorElement = element.newElementMapped("implementor");
        if (this.getFunctor() instanceof IElementSerializable) {
            ((IElementSerializable)((Object)this.getFunctor())).serialize(implementorElement);
        } else if (this.getFunctor() != null) {
            implementorElement.setAttributeValue("class", this.getFunctor().getClass().getName());
        }
        new DeclarationIO().serializeDeclarationBlock(this.getDeclarationBlock(), element);
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        this.context = context;
        if (this.functor instanceof IContextSupport) {
            ((IContextSupport)((Object)this.functor)).setContext(context);
        }
    }

    protected void setFunctor(IFunctor functor) throws ConfigurationException {
        this.functor = functor;
        if (this.context != null && functor instanceof IContextSupport) {
            ((IContextSupport)((Object)functor)).setContext(this.context);
        }
    }
}

