/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.infoset.OutputFormat;
import de.intarsys.tools.infoset.XMLWriter;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.StringWriter;
import java.util.Iterator;

public abstract class AbstractElement
implements IElement {
    private final boolean indexed;

    public AbstractElement(boolean indexed) {
        this.indexed = indexed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asXML() {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(this);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            String string = "<error>";
            return string;
        }
        finally {
            StreamTools.close(writer);
        }
    }

    @Override
    public Object attributeData(String name, Object defaultValue) {
        IAttribute attr = this.attribute(name);
        return attr == null ? defaultValue : attr.getData();
    }

    @Override
    public Iterator<String> attributeNames() {
        return new ConversionIterator<IAttribute, String>(this.attributeIterator()){

            @Override
            protected String createTargetObject(IAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public String attributeValue(String name, String defaultValue) {
        IAttribute attr = this.attribute(name);
        return attr == null ? defaultValue : attr.getValue();
    }

    protected Object basicGetAttributeData(IAttribute attribute, String name) {
        throw new UnsupportedOperationException();
    }

    protected Object basicGetAttributeRaw(IAttribute attribute, String name) {
        throw new UnsupportedOperationException();
    }

    protected String basicGetAttributeValue(IAttribute attribute, String name) {
        throw new UnsupportedOperationException();
    }

    protected void basicSetAttributeData(IAttribute attribute, String name, Object data) {
        throw new UnsupportedOperationException();
    }

    protected void basicSetAttributeRaw(IAttribute attribute, String name, Object raw) {
        throw new UnsupportedOperationException();
    }

    protected void basicSetAttributeValue(IAttribute attribute, String name, String value) {
        throw new UnsupportedOperationException();
    }

    protected Object convertDataToRaw(Object value) {
        return value;
    }

    protected Object convertRawToData(Object raw) {
        return raw;
    }

    @Override
    public Iterator<IElement> elementIterator(final String name) {
        return new FilterIterator<IElement>(this.elementIterator()){

            @Override
            protected boolean accept(IElement object) {
                return LangTools.equals(object.getName(), name);
            }
        };
    }

    @Override
    public void elementRemove(IElement targetElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void elementsClear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String elementText(String name) {
        IElement element = this.element(name);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attribute(name) != null;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributeNames().hasNext();
    }

    @Override
    public boolean hasElements() {
        return this.elementIterator().hasNext();
    }

    @Override
    public boolean hasElements(String name) {
        return this.element(name) != null;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isElement() {
        return true;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public IAttribute newAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IElement newElementIndexed(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IElement newElementMapped(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INode node(String name) {
        IAttribute node = this.attribute(name);
        return node == null ? this.element(name) : node;
    }

    @Override
    public void nodeRemove(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttributeData(String name, Object value) {
        IAttribute attribute = this.newAttribute(name);
        attribute.setData(value);
    }

    @Override
    public void setAttributeValue(String name, String value) {
        IAttribute attribute = this.newAttribute(name);
        attribute.setValue(value);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(String value) {
        if (!StringTools.isEmpty(value)) {
            throw new UnsupportedOperationException();
        }
    }

    public String toString() {
        return this.asXML();
    }

    protected String toString(Object value) {
        return ElementTools.toString(value);
    }
}

