/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorFieldHandler;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ArgsElementAdapter;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementTools {
    private static final Logger Log = LoggerFactory.getLogger(ElementTools.class);
    public static final String PROPERTY_REMOVE = "remove";
    public static final String PROPERTY_INSERT = "insert";
    public static final String ELEMENT_SET = "set";
    public static final String PROPERTY_SET = "set";
    public static final String ELEMENT_GET = "get";
    public static final String ATTR_REF = "ref";
    public static final String ELEMENT_ACCESSOR = "accessor";
    public static final String ELEMENT_NULL = "null";
    public static final String ELEMENT_ARGS = "args";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_OBJECT = "object";
    public static final String ATTR_TYPE = "type";
    public static final String ELEMENT_PERFORM = "perform";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_FACTORY = "factory";
    private static final Pattern PATTERN_SPLIT = Pattern.compile("\\.");
    public static final String ATTR_NAME = "name";
    public static final String ELEMENT_IMPLEMENTATION = "implementation";
    public static final String ELEMENT_METHOD = "method";

    protected static InvocationHandler basicCreateInvocationHandler(IElement element, ClassLoader loader) throws ObjectCreationException {
        return new ElementProxyInvocationHandler(element, loader);
    }

    protected static Object basicCreateProxy(IElement element, Class<?>[] clazzes, ClassLoader loader) throws ObjectCreationException {
        Class[] extendedClasses = new Class[clazzes.length + 1];
        System.arraycopy(clazzes, 0, extendedClasses, 0, clazzes.length);
        extendedClasses[extendedClasses.length - 1] = IAttributeSupport.class;
        InvocationHandler handler = ElementTools.basicCreateInvocationHandler(element, loader);
        return Proxy.newProxyInstance(loader, extendedClasses, handler);
    }

    protected static Class<?> basicCreateProxyClass(Class<?>[] clazzes, ClassLoader loader) throws ObjectCreationException {
        Class[] extendedClasses = new Class[clazzes.length + 1];
        System.arraycopy(clazzes, 0, extendedClasses, 0, clazzes.length);
        extendedClasses[extendedClasses.length - 1] = IAttributeSupport.class;
        return Proxy.getProxyClass(loader, extendedClasses);
    }

    public static void copy(IElement to, IElement from) {
        ElementTools.copyAttributes(to, from);
        ElementTools.copyElements(to, from);
        ElementTools.copyText(to, from);
    }

    public static void copyAttributes(IElement to, IElement from) {
        if (to == null || from == null) {
            return;
        }
        Iterator<IAttribute> iter = from.attributeIterator();
        while (iter.hasNext()) {
            IAttribute attribute = iter.next();
            to.newAttribute(attribute.getName()).setRaw(attribute.getRaw());
        }
    }

    public static void copyElements(IElement to, IElement from) {
        if (to == null || from == null) {
            return;
        }
        Iterator<IElement> iter = from.elementIterator();
        while (iter.hasNext()) {
            IElement child = iter.next();
            IElement newTo = child.isIndexed() ? to.newElementIndexed(child.getName()) : to.newElementMapped(child.getName());
            ElementTools.copy(newTo, child);
        }
    }

    public static void copyText(IElement to, IElement from) {
        if (to == null || from == null) {
            return;
        }
        String text = from.getText();
        if (text != null) {
            to.setText(text);
        }
    }

    public static <T> Class<T> createClass(IElement element, String classAttribute, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        String className = element.attributeValue(classAttribute, null);
        if (StringTools.isEmpty(className)) {
            return null;
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        String[] classNames = className.split("\\;");
        Class[] clazzes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String tempName = classNames[i].trim();
            try {
                clazzes[i] = Class.forName(tempName, true, classLoader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ObjectCreationException("class '" + className + "' not found", (Throwable)e);
            }
        }
        Class clazz = clazzes.length > 1 ? ElementTools.basicCreateProxyClass(clazzes, classLoader) : clazzes[0];
        return clazz;
    }

    protected static IFieldHandler createFieldHandler(IElement element, Object owner, Object context) throws ObjectCreationException {
        IElement setElement;
        if (element == null) {
            return null;
        }
        if (element.attributeValue(ATTR_CLASS, null) != null || element.attributeValue(ATTR_FACTORY, null) != null) {
            return ElementTools.createObject(element, IFieldHandler.class, context, Args.create());
        }
        FunctorFieldHandler tempAccessor = new FunctorFieldHandler();
        IElement getElement = element.element(ELEMENT_GET);
        if (getElement != null) {
            tempAccessor.setGetter(ElementTools.createFunctor(owner, getElement, null, context));
        }
        if ((setElement = element.element("set")) != null) {
            tempAccessor.setSetter(ElementTools.createFunctor(owner, setElement, null, context));
        }
        tempAccessor.setName(element.attributeValue(ATTR_NAME, "unknown"));
        return tempAccessor;
    }

    public static IFunctor<?> createFunctor(Object owner, IElement element, String role, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        IFunctor<Object> functor = null;
        IElement codeExitElement = element.element(ELEMENT_PERFORM);
        if (codeExitElement != null) {
            functor = CodeExit.createFromElement(codeExitElement);
            functor.setOwner(owner);
            functor.setClassLoader(ElementTools.getClassLoader(context, CodeExit.class));
        } else {
            functor = ElementTools.createObject(element, role, IFunctor.class, context, Args.create());
        }
        return functor;
    }

    public static <T> T createObject(IElement element, Class<T> expectedClass, Object context, IArgs initProperties) throws ObjectCreationException {
        return ElementTools.createObject(element, null, expectedClass, context, initProperties);
    }

    public static <T> T createObject(IElement element, String role, Class<T> expectedClass, Object context, IArgs initProperties) throws ObjectCreationException {
        Object attributeName;
        String target;
        if (element == null) {
            return null;
        }
        if (role == null) {
            role = "";
        }
        if (role.length() > 0 && (target = element.attributeValue((String)(attributeName = role), null)) != null) {
            return ElementTools.createObjectFromClass(element, target, expectedClass, context, initProperties);
        }
        attributeName = role + ATTR_REF;
        target = element.attributeValue((String)attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromContainer(element, target, expectedClass, context);
        }
        attributeName = role + ATTR_CLASS;
        target = element.attributeValue((String)attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromClass(element, target, expectedClass, context, initProperties);
        }
        attributeName = role + ATTR_FACTORY;
        target = element.attributeValue((String)attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromFactory(element, target, expectedClass, context);
        }
        Iterator<IElement> it = element.elementIterator();
        if (it.hasNext()) {
            return ElementTools.createObjectChild(null, it.next(), expectedClass, context);
        }
        throw new ObjectCreationException("can't create object (no 'ref', 'class' or 'factory'");
    }

    public static <T> T createObjectChild(Object owner, IElement element, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (ELEMENT_OBJECT.equals(name)) {
            return ElementTools.createObject(element, expectedClass, context, Args.create());
        }
        if (ELEMENT_VALUE.equals(name)) {
            String value = element.getText();
            String typeName = element.attributeValue(ATTR_TYPE, null);
            return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, expectedClass));
        }
        if (ELEMENT_ARGS.equals(name)) {
            DeclarationBlock block = new DeclarationBlock(owner);
            new DeclarationIO().deserializeDeclarationElements(block, element, false);
            Args value = Args.create();
            try {
                new ArgumentDeclarator().apply(block, value);
            }
            catch (DeclarationException e) {
                throw new ObjectCreationException(e);
            }
            String typeName = element.attributeValue(ATTR_TYPE, null);
            return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, expectedClass));
        }
        if (ELEMENT_NULL.equals(name)) {
            return null;
        }
        if (ELEMENT_PERFORM.equals(name)) {
            CodeExit<?> functor = CodeExit.createFromElement(element);
            functor.setOwner(owner);
            functor.setClassLoader(ElementTools.getClassLoader(context, expectedClass));
            try {
                return (T)functor.perform(FunctorCall.noargs(owner));
            }
            catch (FunctorException e) {
                throw new ObjectCreationException(e);
            }
        }
        if (ELEMENT_ACCESSOR.equals(name)) {
            return (T)ElementTools.createFieldHandler(element, owner, context);
        }
        throw new ObjectCreationException("unknown value element '" + name + "'");
    }

    protected static <T> T createObjectFromAttribute(IAttribute attribute, Class<T> clazz) throws ObjectCreationException {
        if (attribute == null) {
            return null;
        }
        if (clazz == Object.class) {
            return (T)attribute.getData();
        }
        if (clazz == String.class) {
            return (T)attribute.getValue();
        }
        Object value = attribute.getData();
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        try {
            return ObjectTools.createObject(clazz, clazz, new Class[]{Object.class}, new Object[]{value});
        }
        catch (Exception ex) {
            throw ExceptionTools.unwrapTyped(ex, ObjectCreationException.class);
        }
    }

    protected static <T> T createObjectFromClass(IElement element, String className, Class<T> expectedClass, Object context, IArgs initProperties) throws ObjectCreationException {
        if (className == null) {
            throw new ObjectCreationException("class name missing");
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        String[] classNames = className.split("\\;");
        Class[] clazzes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String tempName = classNames[i].trim();
            try {
                clazzes[i] = Class.forName(tempName, false, classLoader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ObjectCreationException("class '" + className + "' not found", (Throwable)e);
            }
        }
        Object object = clazzes.length > 1 || clazzes[0].isInterface() ? ElementTools.basicCreateProxy(element, clazzes, classLoader) : ObjectTools.createObject(clazzes[0], expectedClass);
        try {
            if (object instanceof IContextSupport) {
                ((IContextSupport)object).setContext(context);
            }
            if (object instanceof IClassLoaderAccess) {
                ((IClassLoaderAccess)object).setClassLoader(classLoader);
            }
            if (object instanceof IElementConfigurable) {
                ((IElementConfigurable)object).configure(element);
            }
            ElementTools.setProperties(object, element, classLoader);
            ObjectTools.setProperties(object, initProperties);
            ObjectTools.initObject(object);
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
        return (T)object;
    }

    protected static <T> T createObjectFromContainer(IElement element, String refName, Class<T> expectedClass, Object context) throws ObjectCreationException {
        T object = BeanContainer.get().lookupBean(refName, expectedClass);
        try {
            if (object instanceof IElementConfigurable) {
                ((IElementConfigurable)object).configure(element);
            }
            ElementTools.setProperties(object, element, context);
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
        return object;
    }

    protected static <T> T createObjectFromElement(IElement objectElement, Class<T> clazz, Throwing.Specific.Function<IElement, T, Exception> factory) throws ObjectCreationException {
        T object;
        try {
            if (factory == null) {
                object = ObjectTools.createObject(clazz);
                if (object instanceof IElementConfigurable) {
                    IElementConfigurable configurable = (IElementConfigurable)object;
                    configurable.configure(objectElement);
                }
            } else {
                object = factory.apply(objectElement);
            }
        }
        catch (Exception ex) {
            throw ExceptionTools.unwrapTyped(ex, ObjectCreationException.class);
        }
        return object;
    }

    protected static <T> T createObjectFromFactory(IElement element, String factoryName, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (factoryName == null) {
            throw new ObjectCreationException("factory name missing");
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        IFactory<?> factory = FactoryTools.lookupFactoryFuzzy(factoryName, classLoader);
        if (factory == null) {
            throw new ObjectCreationException("factory '" + factoryName + "' missing");
        }
        Args args = Args.create();
        args.put("context", context);
        args.put("configuration", (Object)element);
        return (T)factory.createInstance(args);
    }

    public static <T> T createPropertyValue(Object owner, IElement element, Class<T> expectedClass, Object context) throws ObjectCreationException {
        IElement valueElement = null;
        Iterator<IElement> itElement = element.elementIterator();
        if (itElement.hasNext()) {
            valueElement = itElement.next();
            if (itElement.hasNext()) {
                throw new ObjectCreationException("too many children");
            }
            return ElementTools.createObjectChild(owner, valueElement, expectedClass, context);
        }
        String ref = element.attributeValue(ATTR_REF, null);
        if (ref != null) {
            return BeanContainer.get().lookupBean(ref, expectedClass);
        }
        Object value = element.attributeData(ELEMENT_VALUE, null);
        String typeName = element.attributeValue(ATTR_TYPE, null);
        return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, null));
    }

    public static boolean getBool(IElement element, String attributeName, boolean defaultValue) {
        return ElementTools.getBoolean(element, attributeName, defaultValue);
    }

    public static boolean getBoolean(IElement element, String attributeName, boolean defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Boolean getBooleanObject(IElement element, String attributeName, Boolean defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (!StringTools.isEmpty(value)) {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static char[] getCharArray(IElement element, String attributeName, char[] defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value == null) {
            return defaultValue;
        }
        return value.toCharArray();
    }

    protected static <T> ClassLoader getClassLoader(Object context, Class<T> expectedClass) {
        ClassLoader classLoader = null;
        if (context instanceof ClassLoader) {
            classLoader = (ClassLoader)context;
        } else if (context instanceof IClassLoaderSupport) {
            classLoader = ((IClassLoaderSupport)context).getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null && expectedClass != null) {
            classLoader = expectedClass.getClassLoader();
        }
        return classLoader;
    }

    public static Color getColor(IElement element, String name, Color defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String optionValue = element.attributeValue(name, null);
        if (optionValue == null) {
            return defaultValue;
        }
        try {
            return Color.decode(optionValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDouble(IElement element, String attributeName, double defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static IElement getElement(IElement element, String elementName) {
        if (element == null) {
            return null;
        }
        return element.element(elementName);
    }

    public static <T extends EnumItem> T getEnumItem(IElement element, String attributeName, EnumMeta<T> meta) {
        String id = ElementTools.getString(element, attributeName, null);
        return meta.getItemOrDefault(id);
    }

    public static <T extends EnumItem> T getEnumItem(IElement element, String attributeName, EnumMeta<T> meta, T defaultValue) {
        String id = ElementTools.getString(element, attributeName, null);
        T result = null;
        if (id != null) {
            result = meta.getItem(id);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static float getFloat(IElement element, String attributeName, float defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getInt(IElement element, String attributeName, int defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        return Converter.asInteger(value, defaultValue);
    }

    public static long getLong(IElement element, String attributeName, long defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T> T getObject(IElement element, String name, Class<T> clazz) throws ObjectCreationException {
        return ElementTools.getObject(element, name, clazz, null);
    }

    public static <T> T getObject(IElement element, String name, Class<T> clazz, Throwing.Specific.Function<IElement, T, Exception> factory) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        IElement child = element.element(name);
        if (child == null) {
            IAttribute attribute = element.attribute(name);
            return ElementTools.createObjectFromAttribute(attribute, clazz);
        }
        return ElementTools.createObjectFromElement(child, clazz, factory);
    }

    public static boolean getPathBoolean(IElement element, String path, boolean defaultValue) {
        int i;
        IElement nextElement = element;
        String[] split = PATTERN_SPLIT.split(path, 0);
        int count = split.length - 1;
        for (i = 0; nextElement != null && i < count; nextElement = nextElement.element(split[i]), ++i) {
        }
        return ElementTools.getBoolean(nextElement, split[i], defaultValue);
    }

    public static double getPathDouble(IElement element, String path, double defaultValue) {
        int i;
        IElement nextElement = element;
        String[] split = PATTERN_SPLIT.split(path, 0);
        int count = split.length - 1;
        for (i = 0; nextElement != null && i < count; nextElement = nextElement.element(split[i]), ++i) {
        }
        return ElementTools.getDouble(nextElement, split[i], defaultValue);
    }

    public static IElement getPathElement(IElement element, String path) {
        String[] split = PATTERN_SPLIT.split(path, 0);
        return ElementTools.getPathElement(element, split);
    }

    public static IElement getPathElement(IElement element, String ... segments) {
        IElement nextElement;
        int count = segments.length - 1;
        int i = 0;
        for (nextElement = element; nextElement != null && i < count; nextElement = nextElement.element(segments[i]), ++i) {
        }
        return ElementTools.getElement(nextElement, segments[i]);
    }

    public static float getPathFloat(IElement element, String path, float defaultValue) {
        int i;
        IElement nextElement = element;
        String[] split = PATTERN_SPLIT.split(path, 0);
        int count = split.length - 1;
        for (i = 0; nextElement != null && i < count; nextElement = nextElement.element(split[i]), ++i) {
        }
        return ElementTools.getFloat(nextElement, split[i], defaultValue);
    }

    public static int getPathInt(IElement element, String path, int defaultValue) {
        int i;
        IElement nextElement = element;
        String[] split = PATTERN_SPLIT.split(path, 0);
        int count = split.length - 1;
        for (i = 0; nextElement != null && i < count; nextElement = nextElement.element(split[i]), ++i) {
        }
        return ElementTools.getInt(nextElement, split[i], defaultValue);
    }

    public static String getPathString(IElement element, String path, String defaultValue) {
        int i;
        IElement nextElement = element;
        String[] split = PATTERN_SPLIT.split(path, 0);
        int count = split.length - 1;
        for (i = 0; nextElement != null && i < count; nextElement = nextElement.element(split[i]), ++i) {
        }
        return ElementTools.getString(nextElement, split[i], defaultValue);
    }

    public static Secret getSecretHide(IElement element, String name, Secret defaultValue) {
        Object value = null;
        if (element != null) {
            value = element.attributeData(name, null);
        }
        try {
            Secret secret = CryptoTools.createSecret(value);
            if (CryptoTools.isEmpty(secret)) {
                return defaultValue;
            }
            return secret;
        }
        catch (Exception e) {
            Log.warn("element property '{}' value of type {} not supported", (Object)name, value);
            return defaultValue;
        }
    }

    public static Secret getSecretParse(IElement element, String name, Secret defaultValue) {
        Object value = null;
        if (element != null) {
            value = element.attributeData(name, null);
        }
        if (LangTools.isEmpty(value)) {
            return defaultValue;
        }
        if (value instanceof Secret) {
            return (Secret)value;
        }
        if (value instanceof String) {
            return Secret.parse((String)value);
        }
        Log.warn("element property '{}' value of type {} not supported", (Object)name, value);
        return defaultValue;
    }

    public static Secret getSecretTemplate(IElement element, String name, Secret defaultValue) {
        Object value = null;
        if (element != null) {
            value = element.attributeData(name, null);
        }
        if (LangTools.isEmpty(value)) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                value = TemplateEvaluator.get(Mode.TRUSTED).evaluate((String)value, Args.create());
            }
            catch (EvaluationException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (value instanceof Secret) {
            return (Secret)value;
        }
        Log.warn("element property '{}' value of type {} not supported", (Object)name, value);
        return defaultValue;
    }

    public static String getString(IElement element, String attributeName, String defaultValue) {
        if (element != null) {
            return element.attributeValue(attributeName, defaultValue);
        }
        return defaultValue;
    }

    protected static boolean isPrimitive(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof Number) {
            return true;
        }
        return value instanceof Boolean;
    }

    public static IElement parseElement(String value) throws IOException {
        StringReader reader = new StringReader(value);
        return ElementFactory.get().parse(reader).getRootElement();
    }

    public static void putBoolean(IElement element, String name, Boolean value) {
        String tempValue = value == null ? null : value.toString();
        element.setAttributeValue(name, tempValue);
    }

    public static void putNumber(IElement element, String name, Number value) {
        String tempValue = value == null ? null : value.toString();
        element.setAttributeValue(name, tempValue);
    }

    public static INode putObject(IElement container, String name, Object value) throws ElementSerializationException {
        if (value == null) {
            container.nodeRemove(name);
            return null;
        }
        if (ElementTools.isPrimitive(value)) {
            container.setAttributeData(name, value);
            return container.attribute(name);
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            IElement newElement = args.isNamed() ? container.newElementMapped(name) : container.newElementIndexed(name);
            ElementTools.copy(newElement, new ArgsElementAdapter(args));
            return newElement;
        }
        if (value instanceof Map) {
            IElement newElement = container.newElementMapped(name);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ElementTools.putObject(newElement, (String)entry.getKey(), entry.getValue());
            }
            return newElement;
        }
        if (value instanceof List) {
            List list = (List)value;
            IElement newElement = container.newElementIndexed(name);
            for (Object item : list) {
                ElementTools.putObject(newElement, "item", item);
            }
            return newElement;
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            IElement newElement = container.newElementIndexed(name);
            for (Object item : array) {
                ElementTools.putObject(newElement, "item", item);
            }
            return newElement;
        }
        if (value instanceof IElementSerializable) {
            return ((IElementSerializable)value).serialize(container, name);
        }
        IElement newElement = container.newElementMapped(name);
        newElement.setAttributeValue(ATTR_CLASS, value.getClass().getName());
        newElement.setAttributeValue(ELEMENT_VALUE, value.toString());
        return newElement;
    }

    public static void putSecretTemplate(IElement element, String name, Secret value) {
        String tempValue = value == null || value.isEmpty() ? null : "${secret." + value.getEncoded() + "}";
        element.newAttribute(name).setRaw(tempValue);
    }

    public static void putSecretValue(IElement element, String name, Secret value) {
        String tempValue = value == null || value.isEmpty() ? null : value.getEncoded();
        element.setAttributeValue(name, tempValue);
    }

    public static void setCDATA(IElement element, String value) {
        String cdata = "<![CDATA[" + value + "]]>";
        element.setText(cdata);
    }

    public static void setProperties(Object object, IElement element, Object context) throws FieldException, ObjectCreationException {
        INode elProperty;
        Iterator<INode> itProperties;
        IElement elProperties = element.element("properties");
        if (elProperties != null) {
            itProperties = elProperties.nodeIterator();
            while (itProperties.hasNext()) {
                elProperty = itProperties.next();
                ElementTools.setProperty(object, elProperty, context);
            }
        }
        itProperties = element.elementIterator("property");
        while (itProperties.hasNext()) {
            elProperty = (IElement)itProperties.next();
            ElementTools.setProperty(object, elProperty, context);
        }
    }

    public static void setProperty(Object object, INode node, Object context) throws FieldException, ObjectCreationException {
        if (node.isAttribute()) {
            String property = ((IAttribute)node).getName();
            Object value = ((IAttribute)node).getData();
            ObjectTools.set(object, property, value);
        } else {
            IElement element = (IElement)node;
            String property = element.attributeValue(ATTR_NAME, null);
            String operation = element.attributeValue("operation", "set");
            Object value = ElementTools.createPropertyValue(object, element, Object.class, context);
            if ("set".equals(operation)) {
                ObjectTools.set(object, property, value);
            } else if (PROPERTY_INSERT.equals(operation)) {
                ObjectTools.insert(object, property, value);
            } else if (PROPERTY_REMOVE.equals(operation)) {
                ObjectTools.remove(object, property, value);
            } else {
                throw new ObjectCreationException("unknown property operation '" + operation + "'");
            }
        }
    }

    public static IElement toElement(IArgs args) {
        if (args == null) {
            return null;
        }
        return new ArgsElementAdapter("arg", args);
    }

    public static Object toJavaDeep(INode node) {
        if (node == null) {
            return null;
        }
        if (node.isAttribute()) {
            return ((IAttribute)node).getData();
        }
        IElement element = (IElement)node;
        if (element.isIndexed()) {
            ArrayList<Object> result = new ArrayList<Object>();
            Iterator<INode> it = element.nodeIterator();
            while (it.hasNext()) {
                INode childNode = it.next();
                result.add(ElementTools.toJavaDeep(childNode));
            }
            return result;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Iterator<INode> it = element.nodeIterator();
        while (it.hasNext()) {
            INode childNode = it.next();
            result.put(childNode.getName(), ElementTools.toJavaDeep(childNode));
        }
        return result;
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Secret) {
            return CryptoTools.getString((Secret)value, null);
        }
        return String.valueOf(value);
    }

    public static void write(ContentHandler handler, IElement element) throws SAXException {
        ElementTools.writeElementStart(handler, element);
        ElementTools.writeElementContent(handler, element);
        ElementTools.writeElementEnd(handler, element);
    }

    protected static void writeElementContent(ContentHandler handler, IElement element) throws SAXException {
        ElementTools.writeElementText(handler, element);
        Iterator<IElement> iter = element.elementIterator();
        while (iter.hasNext()) {
            IElement child = iter.next();
            ElementTools.write(handler, child);
        }
    }

    protected static void writeElementEnd(ContentHandler handler, IElement element) throws SAXException {
        handler.endElement("", element.getName(), element.getName());
    }

    protected static void writeElementStart(ContentHandler handler, IElement element) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        Iterator<IAttribute> iter = element.attributeIterator();
        while (iter.hasNext()) {
            IAttribute attribute = iter.next();
            Object raw = attribute.getRaw();
            if (raw == null) continue;
            attributes.addAttribute("", attribute.getName(), attribute.getName(), "CDATA", String.valueOf(raw));
        }
        handler.startElement("", element.getName(), element.getName(), attributes);
    }

    protected static void writeElementText(ContentHandler handler, IElement element) throws SAXException {
        if (element.getText() != null) {
            char[] chars = element.getText().toCharArray();
            handler.characters(chars, 0, chars.length);
        }
    }

    private ElementTools() {
    }

    static class ElementProxyInvocationHandler
    implements InvocationHandler,
    IAttributeSupport {
        private AttributeMap attributes;
        private Map<String, IFunctor<?>> functors = new HashMap();

        public ElementProxyInvocationHandler(IElement element, ClassLoader loader) throws ObjectCreationException {
            this.createFunctors(element, loader);
        }

        protected void createFunctors(IElement element, ClassLoader loader) throws ObjectCreationException {
            IElement implementation = element.element(ElementTools.ELEMENT_IMPLEMENTATION);
            if (implementation != null) {
                Iterator<IElement> it = implementation.elementIterator(ElementTools.ELEMENT_METHOD);
                while (it.hasNext()) {
                    IElement methodElement = it.next();
                    String name = methodElement.attributeValue(ElementTools.ATTR_NAME, null);
                    IFunctor<?> functor = ElementTools.createFunctor(this, methodElement, null, loader);
                    this.functors.put(name, functor);
                }
            }
            IFunctor<Object> tempFunctor = new IFunctor<Object>(){

                @Override
                public Object perform(IFunctorCall call) throws FunctorException {
                    return this.getAttribute(call.getArgs().get(0));
                }
            };
            this.functors.put("getAttribute", tempFunctor);
            tempFunctor = new IFunctor<Object>(){

                @Override
                public Object perform(IFunctorCall call) throws FunctorException {
                    return this.setAttribute(call.getArgs().get(0), call.getArgs().get(1));
                }
            };
            this.functors.put("setAttribute", tempFunctor);
            tempFunctor = new IFunctor<Object>(){

                @Override
                public Object perform(IFunctorCall call) throws FunctorException {
                    return this.removeAttribute(call.getArgs().get(0));
                }
            };
            this.functors.put("removeAttribute", tempFunctor);
        }

        @Override
        public Object getAttribute(Object key) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(key);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            IFunctor<?> functor = this.functors.get(name);
            if (functor == null) {
                return null;
            }
            Args functorArgs = new Args(args);
            FunctorCall call = new FunctorCall(proxy, functorArgs);
            return functor.perform(call);
        }

        @Override
        public Object removeAttribute(Object key) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.remove(key);
        }

        @Override
        public Object setAttribute(Object key, Object o) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap();
            }
            return this.attributes.put(key, o);
        }
    }
}

