/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.AbstractElement;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.infoset.StandardAttribute;
import de.intarsys.tools.infoset.StandardDocument;
import de.intarsys.tools.reader.DirectTagReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class StandardElement
extends AbstractElement {
    private StandardElement parent;
    private StandardDocument document;
    private String text = "";
    private List<IElement> elements;
    private Map<String, IAttribute> attributes;
    private String name;

    public StandardElement(StandardDocument document, StandardElement parent, String name, boolean indexed) {
        super(indexed);
        this.document = document;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public IAttribute attribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Iterator<IAttribute> attributeIterator() {
        if (this.attributes == null) {
            return Collections.emptyIterator();
        }
        return this.attributes.values().iterator();
    }

    @Override
    public Iterator<String> attributeNames() {
        if (this.attributes == null) {
            return Collections.emptyIterator();
        }
        return this.attributes.keySet().iterator();
    }

    @Override
    protected Object convertDataToRaw(Object data) {
        if (data == null) {
            return null;
        }
        return DirectTagReader.escape(String.valueOf(data));
    }

    @Override
    protected Object convertRawToData(Object raw) {
        if (raw == null) {
            return raw;
        }
        if (this.getParent() != null) {
            return this.getParent().convertRawToData(raw);
        }
        if (this.document != null) {
            return this.document.convertRawToData(raw);
        }
        return raw;
    }

    @Override
    public IElement element(String name) {
        if (this.elements == null) {
            return null;
        }
        for (IElement element : this.elements) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public Iterator<IElement> elementIterator() {
        if (this.elements == null) {
            return Collections.emptyIterator();
        }
        return this.elements.iterator();
    }

    @Override
    public void elementRemove(IElement pElement) {
        if (this.elements == null) {
            return;
        }
        this.elements.remove(pElement);
    }

    @Override
    public void elementsClear() {
        if (this.elements == null) {
            return;
        }
        this.elements.clear();
    }

    protected StandardAttribute ensureAttribute(String name) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, IAttribute>();
        }
        StandardAttribute attr = new StandardAttribute(this, name);
        this.attributes.put(name, attr);
        return attr;
    }

    public StandardDocument getDocument() {
        return this.document;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public StandardElement getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    @Override
    public boolean hasElements() {
        return this.elements != null && !this.elements.isEmpty();
    }

    @Override
    public IAttribute newAttribute(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        StandardAttribute attr = this.ensureAttribute(name);
        return attr;
    }

    @Override
    public IElement newElementIndexed(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        StandardElement result = new StandardElement(this.document, this, name, true);
        if (this.elements == null) {
            this.elements = new ArrayList<IElement>();
        }
        this.elements.add(result);
        return result;
    }

    @Override
    public IElement newElementMapped(String name) {
        if (!this.isIndexed()) {
            Objects.requireNonNull(name, "name cannot be null");
        }
        StandardElement result = new StandardElement(this.document, this, name, false);
        if (this.elements == null) {
            this.elements = new ArrayList<IElement>();
        }
        this.elements.add(result);
        return result;
    }

    @Override
    public Iterator<INode> nodeIterator() {
        return Stream.concat(this.elements == null ? Stream.empty() : this.elements.stream(), this.attributes == null ? Stream.empty() : this.attributes.values().stream()).iterator();
    }

    @Override
    public void nodeRemove(String name) {
        if (this.elements != null) {
            for (IElement element : this.elements) {
                if (!element.getName().equals(name)) continue;
                this.elements.remove(element);
            }
        }
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public void setAttributeData(String name, Object value) {
        Objects.requireNonNull(name, "name cannot be null");
        if (value == null) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(name);
        } else {
            StandardAttribute attr = this.ensureAttribute(name);
            attr.setData(value);
        }
    }

    @Override
    public void setAttributeValue(String name, String value) {
        Objects.requireNonNull(name, "name cannot be null");
        if (value == null) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(name);
        } else {
            StandardAttribute attr = this.ensureAttribute(name);
            attr.setValue(value);
        }
    }

    public void setDocument(StandardDocument document) {
        this.document = document;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setParent(StandardElement parent) {
        this.parent = parent;
    }

    @Override
    public void setText(String value) {
        this.text = value;
    }

    @Override
    public String toString() {
        return this.asXML();
    }

    @Override
    protected String toString(Object value) {
        return ElementTools.toString(value);
    }
}

