/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ITransientLocatorFactory;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTransientLocatorFactory
implements ITransientLocatorFactory {
    private static final Logger Log = LoggerFactory.getLogger(PlainTransientLocatorFactory.class);
    private long maxBufferSize = 0xA00000L;

    @Override
    public ILocator createLocator(ILocator locator) throws IOException {
        long size = locator.getLength();
        String name = locator.getName();
        if (size >= 0L && size < this.getMaxBufferSize()) {
            return new ByteArrayLocator(new byte[(int)size], 0, name);
        }
        File tempFile = FileTools.createTempFile(name);
        Log.trace("create plain transient locator at '{}'", (Object)tempFile);
        return new FileLocator(tempFile);
    }

    public long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }
}

