/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.ClassLoaderResourceLocatorFactory;
import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.HttpLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SchemeBasedLocatorFactory
extends CommonLocatorFactory {
    private ILocatorFactory noSchemeLocatorFactory;
    private ILocatorFactory unknownSchemeLocatorFactory;
    private Map<String, ILocatorFactory> factories = new HashMap<String, ILocatorFactory>();

    public static SchemeBasedLocatorFactory createDefault() {
        SchemeBasedLocatorFactory lf = new SchemeBasedLocatorFactory();
        lf.registerLocatorFactory("file", new FileLocatorFactory());
        lf.registerLocatorFactory("classpath", new ClassLoaderResourceLocatorFactory((ClassLoader)null));
        lf.registerLocatorFactory("http", new HttpLocatorFactory("http"));
        lf.registerLocatorFactory("https", new HttpLocatorFactory("https"));
        lf.setNoSchemeLocatorFactory(new FileLocatorFactory());
        return lf;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        String[] parts = location.split("\\:", 2);
        String tempLocation = location;
        ILocatorFactory factory = null;
        if (parts.length == 1) {
            factory = this.getNoSchemeLocatorFactory();
        } else if (parts[0].length() == 1) {
            factory = this.getNoSchemeLocatorFactory();
        } else {
            factory = this.lookupLocatorFactory(parts[0]);
            if (factory == null) {
                factory = this.getUnknownSchemeLocatorFactory();
            } else {
                tempLocation = parts[1];
            }
        }
        if (factory != null) {
            return factory.createLocator(tempLocation);
        }
        throw new FileNotFoundException("'" + location + "' not found");
    }

    public Map<String, ILocatorFactory> getLocatorFactories() {
        return this.factories;
    }

    public ILocatorFactory getNoSchemeLocatorFactory() {
        return this.noSchemeLocatorFactory;
    }

    public ILocatorFactory getUnknownSchemeLocatorFactory() {
        return this.unknownSchemeLocatorFactory;
    }

    public ILocatorFactory lookupLocatorFactory(String format) {
        return this.factories.get(format);
    }

    public void registerLocatorFactory(String format, ILocatorFactory factory) {
        this.factories.put(format, factory);
    }

    public void setNoSchemeLocatorFactory(ILocatorFactory factory) {
        this.noSchemeLocatorFactory = factory;
    }

    public void setUnknownSchemeLocatorFactory(ILocatorFactory factory) {
        this.unknownSchemeLocatorFactory = factory;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("type", this.getClass().getName(), null);
        printer.appendMember("factories", this.factories, null);
        printer.appendMember("noSchemeFactory", this.noSchemeLocatorFactory, null);
        printer.appendMember("unknownSchemeFactory", this.unknownSchemeLocatorFactory, null);
    }

    public void unregisterLocatorFactory(String format) {
        this.factories.remove(format);
    }
}

