/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.slf4j;

import de.intarsys.tools.logging.EnumLogLevel;
import de.intarsys.tools.string.StringTools;
import org.slf4j.MDC;
import org.slf4j.event.Level;

public class Slf4jTools {
    public static final String LOGGER_ROOT = "";
    public static final String KEY_CORR = "corr";

    public static void addCorrelation(String key, String value) {
        if (StringTools.isEmpty(value)) {
            return;
        }
        String tmpKey = StringTools.isEmpty(key) ? KEY_CORR : key;
        String previous = MDC.get((String)tmpKey);
        String tag = Slf4jTools.createCorrelationTag(value);
        if (StringTools.isEmpty(previous)) {
            MDC.put((String)tmpKey, (String)tag);
        } else if (!previous.contains(tag)) {
            MDC.put((String)tmpKey, (String)(previous + tag));
        }
    }

    protected static String createCorrelationTag(String id) {
        String tag = "(" + id + ")";
        return tag;
    }

    public static void endCorrelation(String key) {
        String tmpKey = StringTools.isEmpty(key) ? KEY_CORR : key;
        MDC.remove((String)tmpKey);
    }

    public static EnumLogLevel fromLevel(Level level) {
        for (EnumLogLevel enumLevel : (EnumLogLevel[])EnumLogLevel.META.getItems()) {
            if (!enumLevel.getLevel().equals(level.toString())) continue;
            return enumLevel;
        }
        return EnumLogLevel.UNDEFINED;
    }

    public static void removeCorrelation(String key, String value) {
        if (StringTools.isEmpty(value)) {
            return;
        }
        String tmpKey = StringTools.isEmpty(key) ? KEY_CORR : key;
        String previous = MDC.get((String)tmpKey);
        if (!StringTools.isEmpty(previous)) {
            String tag = Slf4jTools.createCorrelationTag(value);
            String replace = previous.replace(tag, LOGGER_ROOT);
            MDC.put((String)tmpKey, (String)replace);
        }
    }

    public static Level toLevel(EnumLogLevel eLevel, Level defaultValue) {
        return Slf4jTools.toLevel(eLevel.getLevel(), defaultValue);
    }

    public static Level toLevel(String name, Level defaultValue) {
        for (Level level : Level.values()) {
            if (!level.toString().equals(name)) continue;
            return level;
        }
        return defaultValue;
    }

    private Slf4jTools() {
    }
}

