/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.CombinedResourceBundleControl;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

class CombinedResourceBundle
extends ResourceBundle {
    public static final ResourceBundle.Control CONTROL = new CombinedResourceBundleControl();
    private final Properties properties;

    protected CombinedResourceBundle(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle parent = this.parent;
        return new CombinedResourceBundleEnumeration(this.properties.keySet(), parent != null ? parent.getKeys() : null);
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.properties.get(key);
    }

    static class CombinedResourceBundleEnumeration
    implements Enumeration<String> {
        Set<Object> set;
        Iterator<Object> iterator;
        Enumeration<String> enumeration;
        String next = null;

        public CombinedResourceBundleEnumeration(Set<Object> set, Enumeration enumeration) {
            this.set = set;
            this.iterator = set.iterator();
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = (String)this.iterator.next();
                } else if (this.enumeration != null) {
                    while (this.next == null && this.enumeration.hasMoreElements()) {
                        this.next = this.enumeration.nextElement();
                        if (!this.set.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        @Override
        public String nextElement() {
            if (this.hasMoreElements()) {
                String result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

