/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.monitor.AbstractMonitorTrace;
import de.intarsys.tools.monitor.ISample;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorSample;
import java.io.StringWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.event.Level;

public abstract class MonitorTrace
extends AbstractMonitorTrace {
    private long start;
    private long stop;
    private List samples;

    protected MonitorTrace(Monitor owner) {
        super(owner);
    }

    @Override
    protected ISample basicSample(String description) {
        if (this.samples == null) {
            this.samples = new ArrayList();
        }
        ISample sample = this.createMonitorSample(description);
        this.samples.add(sample);
        return sample;
    }

    @Override
    protected void basicStart() {
        ISample sample = this.createMonitorSample("start");
        this.start = sample.getValue();
        this.stop = -1L;
        if (this.samples != null && !this.samples.isEmpty()) {
            this.samples.clear();
        }
        super.basicStart();
    }

    @Override
    protected void basicStop() {
        ISample sample = this.samples == null ? this.createMonitorSample("stop") : this.sample(Level.INFO, "stop");
        this.stop = sample.getValue();
        super.basicStop();
    }

    protected ISample createMonitorSample(String description) {
        return new MonitorSample(this, description, this.createSampleValue());
    }

    protected abstract long createSampleValue();

    public long getDifference() {
        return this.stop - this.start;
    }

    protected Format getFormat() {
        return ((Monitor)this.getOwner()).getFormat();
    }

    public String getFormattedValue(long value) {
        return this.getFormat().format(value);
    }

    public List getSamples() {
        return this.samples;
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    protected boolean isRelative() {
        return ((Monitor)this.getOwner()).isRelative();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write("[Trace=");
        sw.write(this.getOwner().getName());
        sw.write("][");
        sw.write("start=");
        sw.write(this.getFormattedValue(this.getStart()));
        sw.write(";");
        long oldValue = this.getStart();
        if (this.getSamples() != null) {
            for (ISample sample : this.getSamples()) {
                sw.write(sample.getDescription());
                sw.write("=");
                long value = sample.getValue();
                if (this.isRelative()) {
                    oldValue = sample.getValue();
                    if ((value -= oldValue) > 0L) {
                        sw.write("+");
                    }
                    sw.write(String.valueOf(value));
                } else {
                    sw.write(this.getFormattedValue(value));
                }
                sw.write(";");
            }
        }
        sw.write("stop=");
        long value = this.getStop();
        if (this.isRelative()) {
            value -= oldValue;
            oldValue = this.getStop();
            if (value > 0L) {
                sw.write("+");
            }
            sw.write(String.valueOf(value));
        } else {
            sw.write(this.getFormattedValue(value));
        }
        sw.write("]");
        sw.write("[");
        if (this.isRelative()) {
            sw.write("total=");
            value = this.getStop() - this.getStart();
            if (value > 0L) {
                sw.write("+");
            }
            sw.write(String.valueOf(value));
            sw.write(";");
        }
        if (this.getTags() != null) {
            Iterator i = this.getTags().entrySet().iterator();
            if (i.hasNext()) {
                sw.write(";");
            }
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                sw.write(String.valueOf(entry.getKey()));
                sw.write("=");
                sw.write(String.valueOf(entry.getValue()));
                if (!i.hasNext()) continue;
                sw.write(";");
            }
        }
        sw.write("]");
        return sw.toString();
    }

    @Override
    protected void traceLog() {
        if (this.getOwner().getLogger() != null) {
            this.getOwner().getLogger().atLevel(this.getOwner().getLevel()).log(this.toString());
        }
    }
}

