/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import java.io.IOException;
import java.io.Reader;

public class FillReader
extends Reader {
    private String pattern;
    private boolean closed;
    private int pos;

    public FillReader(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern may not be null");
        }
        this.pattern = pattern;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.pos >= this.pattern.length()) {
            if (this.pattern.length() == 0) {
                return -1;
            }
            this.pos = 0;
        }
        return this.pattern.charAt(this.pos++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int c = this.read();
            if (c == -1) {
                return off - i;
            }
            cbuf[i] = (char)c;
        }
        return len;
    }
}

