/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.ReportStatus;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import java.util.ArrayList;

public class ReportDispatcher
implements IReporterSupport,
IReporter {
    private final Object owner;
    private IReporter[] reporters = new IReporter[2];

    public ReportDispatcher(Object pOwner) {
        this.owner = pOwner;
    }

    @Override
    public synchronized void addReporter(IReporter newReporter) {
        int i;
        if (newReporter == null) {
            throw new NullPointerException("reporter may not be null");
        }
        int length = this.reporters.length;
        for (i = 0; i < length && this.reporters[i] != null; ++i) {
        }
        if (i >= length) {
            IReporter[] tempReporters = new IReporter[length + 4];
            System.arraycopy(this.reporters, 0, tempReporters, 0, length);
            this.reporters = tempReporters;
        }
        this.reporters[i] = newReporter;
    }

    public synchronized void attach(IReporterSupport support) {
        int length = this.reporters.length;
        for (int i = 0; i < length; ++i) {
            support.addReporter(this.reporters[i]);
        }
    }

    public synchronized void clear() {
        this.reporters = new IReporter[4];
    }

    public synchronized void detach(IReporterSupport support) {
        int length = this.reporters.length;
        for (int i = 0; i < length; ++i) {
            support.removeReporter(this.reporters[i]);
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized boolean isEmpty() {
        for (int i = 0; i < this.reporters.length; ++i) {
            if (this.reporters[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void removeReporter(IReporter newReporter) {
        int length = this.reporters.length;
        for (int i = 0; i < length; ++i) {
            if (this.reporters[i] != newReporter) continue;
            this.reporters[i] = null;
            break;
        }
    }

    @Override
    public IProgressMonitor reportActivityStart(IMessage message, int style) {
        final ArrayList<IProgressMonitor> nestedMonitors = new ArrayList<IProgressMonitor>();
        for (IReporter tempReporter : this.reporters) {
            if (tempReporter == null) continue;
            nestedMonitors.add(tempReporter.reportActivityStart(message, style));
        }
        ReportStatus activity = new ReportStatus<IActivity<?>>(null){

            @Override
            public void begin(String name, float totalWork) {
                for (IProgressMonitor nestedMonitor : nestedMonitors) {
                    nestedMonitor.begin(name, totalWork);
                }
                super.begin(name, totalWork);
            }

            @Override
            public void end() {
                for (IProgressMonitor nestedMonitor : nestedMonitors) {
                    nestedMonitor.end();
                }
                super.end();
            }

            @Override
            public void subTask(String name) {
                for (IProgressMonitor nestedMonitor : nestedMonitors) {
                    nestedMonitor.subTask(name);
                }
                super.subTask(name);
            }

            @Override
            public void worked(float amount) {
                for (IProgressMonitor nestedMonitor : nestedMonitors) {
                    nestedMonitor.worked(amount);
                }
                super.worked(amount);
            }
        };
        activity.setMessage(message);
        activity.enter();
        return activity;
    }

    @Override
    public void reportError(String title, String message, Throwable t, int style) {
        for (IReporter tempReporter : this.reporters) {
            if (tempReporter == null) continue;
            tempReporter.reportError(title, message, t, style);
        }
    }

    @Override
    public void reportMessage(String title, String message, int style) {
        for (IReporter tempReporter : this.reporters) {
            if (tempReporter == null) continue;
            tempReporter.reportMessage(title, message, style);
        }
    }

    @Override
    public void reportStatus(String message, int style) {
        for (IReporter tempReporter : this.reporters) {
            if (tempReporter == null) continue;
            tempReporter.reportStatus(message, style);
        }
    }
}

