/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import de.intarsys.tools.servicelocator.ServiceImplementation;
import de.intarsys.tools.servicelocator.ServiceResolverNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolverDefaultResolver<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public T apply(Class<T> lookupClass) {
        Class<? extends IServiceResolver> resolverClass;
        ServiceImplementation implementation = lookupClass.getAnnotation(ServiceImplementation.class);
        if (implementation != null && (resolverClass = implementation.defaultResolver()) != ServiceResolverNull.class) {
            try {
                this.log.trace("ServiceResolver {} resolve {}", (Object)this, lookupClass);
                IServiceResolver resolver = ObjectTools.createObject(resolverClass, IServiceResolver.class);
                ObjectTools.initObject(resolver);
                return (T)resolver.apply(lookupClass);
            }
            catch (ObjectCreationException e) {
                throw new ServiceCreationException("service creation for " + lookupClass + " failed", e);
            }
        }
        return null;
    }
}

