/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

public class Token {
    private final String value;
    private final char quote;
    private boolean eof;

    public Token(String value) {
        this.value = value;
        this.quote = '\u0000';
        this.eof = false;
    }

    public Token(String value, char quote) {
        this.value = value;
        this.quote = quote;
        this.eof = false;
    }

    public Token(String value, char quote, boolean eof) {
        this.value = value;
        this.quote = quote;
        this.eof = eof;
    }

    public char getQuote() {
        return this.quote;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isEof() {
        return this.eof;
    }

    public boolean isQuoted() {
        return this.quote != '\u0000';
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }

    public String toString() {
        return "t" + (this.isQuoted() ? "'" : "") + "(" + this.getValue() + ")";
    }
}

