/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.system;

import de.intarsys.tools.string.StringTools;

public class SystemTools {
    private static final String BINDIR;
    private static final String BASEDIR;
    private static final String LIBDIR;
    private static final String OS_NAME;
    private static final String OS_ARCH;
    private static boolean Citrix;
    private static boolean Windows;
    private static boolean Windows_XP;
    private static boolean Linux;
    private static boolean Mac;
    public static final String DEFAULT_PROFILEDIR_MAC = "${properties.user.home}/Library/Application Support/${app.name:t}_${app.major}.${app.minor}";
    public static final String DEFAULT_PROFILEDIR_NIX = "${properties.user.home}/.${app.name:t:.toLowerCase}-${app.major}.${app.minor}";
    public static final String DEFAULT_PROFILEDIR_WINDOWS = "${properties.user.home}/.${app.name:t}_${app.major}.${app.minor}";
    public static final String DEFAULT_PROFILEDIR_MAC_WO_VERSION = "${properties.user.home}/Library/Application Support/${app.name:t}";
    public static final String DEFAULT_PROFILEDIR_NIX_WO_VERSION = "${properties.user.home}/.${app.name:t:.toLowerCase}";
    public static final String DEFAULT_PROFILEDIR_WINDOWS_WO_VERSION = "${properties.user.home}/.${app.name:t}";

    public static String getBasedir() {
        return BASEDIR;
    }

    public static String getBindir() {
        return BINDIR;
    }

    public static String getDebugSetting(String feature) {
        return System.getProperty("de.intarsys.debug." + feature);
    }

    public static String getLibdir() {
        return LIBDIR;
    }

    public static String getOSArch() {
        return OS_ARCH;
    }

    public static String getOSCode() {
        String tempName = System.getProperty("de.intarsys.platform.os.code");
        if (!StringTools.isEmpty(tempName)) {
            return tempName;
        }
        if (SystemTools.isWindows()) {
            return "windows";
        }
        if (SystemTools.isLinux()) {
            return "linux";
        }
        if (SystemTools.isMac()) {
            return "mac";
        }
        return "other";
    }

    public static String getOSName() {
        return OS_NAME;
    }

    public static boolean isCitrix() {
        return Citrix;
    }

    public static boolean isDebug(String feature) {
        return "true".equals(System.getProperty("de.intarsys.debug." + feature));
    }

    public static boolean isLinux() {
        return Linux;
    }

    public static boolean isMac() {
        return Mac;
    }

    public static boolean isWindows() {
        return Windows;
    }

    public static boolean isWindowsXP() {
        return Windows_XP;
    }

    public static String mapLibraryName(String libname) {
        Object mapped = System.mapLibraryName(libname);
        if (((String)mapped).length() > 6 && ((String)mapped).substring(((String)mapped).length() - 7).equals(".jnilib")) {
            mapped = ((String)mapped).substring(0, ((String)mapped).length() - 7);
            mapped = (String)mapped + ".dylib";
        }
        return mapped;
    }

    public static String mapLibraryName(String libname, String version) {
        Object mapped = SystemTools.mapLibraryName(libname);
        if (((String)mapped).length() > 2 && ((String)mapped).substring(((String)mapped).length() - 3).equals(".so")) {
            mapped = (String)mapped + "." + version;
        }
        return mapped;
    }

    private SystemTools() {
    }

    static {
        String tempName = System.getProperty("de.intarsys.platform.os.name");
        String tempArch = System.getProperty("de.intarsys.platform.os.arch", "x86");
        if (tempName == null) {
            tempName = System.getProperty("os.name");
            tempArch = System.getProperty("os.arch");
        }
        OS_NAME = tempName;
        OS_ARCH = tempArch;
        String osNameLowerCase = OS_NAME.toLowerCase();
        if (osNameLowerCase.startsWith("win")) {
            Windows = true;
            if ("windows xp".equals(osNameLowerCase)) {
                Windows_XP = true;
            }
            LIBDIR = "bin";
            BINDIR = "bin";
            BASEDIR = "";
        } else if (osNameLowerCase.startsWith("linux")) {
            Linux = true;
            if ("amd64".equals(OS_ARCH)) {
                BINDIR = "bin";
                LIBDIR = "lib/amd64";
            } else {
                BINDIR = "bin";
                LIBDIR = "lib/i386";
            }
            BASEDIR = "";
        } else if (osNameLowerCase.startsWith("mac")) {
            Mac = true;
            LIBDIR = "MacOS";
            BINDIR = "MacOS";
            BASEDIR = "Resources";
        } else {
            BASEDIR = "";
            LIBDIR = "";
            BINDIR = "";
        }
        Citrix = Boolean.getBoolean("de.intarsys.platform.citrix");
    }
}

