/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.writer;

import java.io.IOException;
import java.io.Writer;

public class EscapeWriter
extends Writer {
    private Writer out;
    private String destinationChars = "\\nrt";
    private String sourceChars = "\\\n\r\t";

    public EscapeWriter(Writer o) {
        super((Object)o);
        this.setOut(o);
    }

    @Override
    public void close() throws IOException {
        this.getOut().close();
    }

    @Override
    public void flush() throws IOException {
        this.getOut().flush();
    }

    public String getDestinationChars() {
        return this.destinationChars;
    }

    public Writer getOut() {
        return this.out;
    }

    public String getSourceChars() {
        return this.sourceChars;
    }

    public void setDestinationChars(String newDestinationChars) {
        this.destinationChars = newDestinationChars;
    }

    private void setOut(Writer newOut) {
        this.out = newOut;
    }

    public void setSourceChars(String newSourceChars) {
        this.sourceChars = newSourceChars;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int index = this.getSourceChars().indexOf(cbuf[i]);
            if (index >= 0) {
                this.out.write(92);
                this.out.write(this.getDestinationChars().charAt(index));
                continue;
            }
            this.out.write(cbuf[i]);
        }
    }
}

